<?php

header( 'Content-Type: text/html; charset=utf-8');
date_default_timezone_set("Asia/Kolkata");
session_start();

header("Cache-Control: no cache");
session_cache_limiter("private_no_expire");	

***


$added_by	=	"";

$project_title="Eagle - Server App";

class db_functions
{
	private $con;
	
	function __construct()
	{
		$this->con = new mysqli("localhost","bebyu_main_user","Tp1.jeC*ztS-","bebyu_main_db");
		//$this->con = new mysqli("localhost","root","","bebyu_newapp_main_db");
	    mysqli_set_charset($this->con, 'utf8');
	}
	
	function get_admin_password($email)
	{
		if($stmt = $this->con->prepare("SELECT `password` FROM `admin` WHERE `user_id` = ?"))
		{
			$stmt->bind_param("s",$email);
			
			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
				return False;
			}
		}
	}
	
	function get_current_status_of_market($res_id,$stat)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `market_setting` WHERE `main_business_title`=? AND `sub_title`=?"))
		{
			$stmt->bind_param("ss",$res_id,$stat);
			
			$stmt->bind_result($res_res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_res_id;
				}
				return False;
			}
		}
	}
	
	function get_market_name_from_market_id($res_id)
	{
		if($stmt = $this->con->prepare("SELECT `market_name` FROM `market` WHERE `id` = ?"))
		{
			$stmt->bind_param("i",$res_id);
			
			$stmt->bind_result($res_name);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_name;
				}
				return False;
			}
		}
	}
	
	function get_market_id_from_market_name($market_name)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `market` WHERE `market_name` = ?"))
		{
			$stmt->bind_param("s",$market_name);
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
				return False;
			}
		}
	}
		
	function register_new_agent($agent_name,$address,$mobile_no,$commission,$agent_user_id,$password,$jodi_commission,$single_pana_commission,$double_pana_commission,$triple_pana_commissions,$police_station,$agent_commission,$sangam_rate,$chitthiwala)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `agent`(`name`, `address`, `mobile_no`, `commission`, `user_id`, `password`, `date`, `time`,`jodi_commission`, `single_pana_commission`, `double_pana_commission`, `triple_pana_commissions`,`police_station`,`agent_commission`,`sangam_rate`,`chitthiwala`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssssssssss",$agent_name,$address,$mobile_no,$commission,$agent_user_id,$password,$date,$time,$jodi_commission,$single_pana_commission,$double_pana_commission,$triple_pana_commissions,$police_station,$agent_commission,$sangam_rate,$chitthiwala);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function add_market_setting_mrkt($res_id,$stat)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `market_setting`(`main_business_title`, `sub_title`, `date`, `time`) VALUES (?,?,?,?)"))
		{
			$stmt->bind_param("ssss",$res_id,$stat,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_market_setting($res_id,$stat)
	{
		if($stmt = $this->con->prepare("Delete from `market_setting` WHERE `main_business_title`=? AND `sub_title`=?"))
		{
			$stmt->bind_param("ss",$res_id,$stat);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_magil_nave($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `chalu_nave` from `finance_manager` where `agent_id` = ? AND `saved_date`!=? AND `saved_date` < ? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("sss",$agent_res_id,$search_date,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	function get_plus_minus_data_from_vasuli_kagad($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `farak_dhanda`, `farak_jama` FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=? AND (`farak_dhanda`!='' OR `farak_jama`!='')"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_farak_dhanda,$res_farak_jama);
			
			if($stmt->execute())
			{
				$data = array();
				$cntr = 0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_farak_dhanda;
					$data[$cntr][1]	=	$res_farak_jama;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_vasuli_vatap_data_for_vasuli_kagad($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `vasuli`, `vatap` FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=? AND (`vasuli`!='' OR `vatap`!='')"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_vasuli,$res_vatap);
			
			if($stmt->execute())
			{
				$data = array();
				$cntr = 0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_vasuli;
					$data[$cntr][1]	=	$res_vatap;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_chalu_nave_chalu_jama($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `chalu_nave`,`chalu_jama` from `finance_manager` where `agent_id` = ? AND `saved_date`=? AND (`farak_dhanda` > 0 OR `farak_jama` > 0) ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_chalu_nave,$res_chalu_jama);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_chalu_nave;
					$data[1]	=	$res_chalu_jama;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_vasuli_vatap_data($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];

		if($stmt = $this->con->prepare("Select `vasuli`,`vatap` from `finance_manager` where `agent_id` = ? AND `saved_date`=? AND (`vasuli`!='' OR `vatap`!='') ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_vasuli,$res_vatap);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_vasuli;
					$data[1]	=	$res_vatap;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	
	
	function get_shillak_data($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `chalu_nave`,`chalu_jama` from `finance_manager` where `agent_id` = ? AND `saved_date` =? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_chalu_nave,$res_chalu_jama);
			
			if($stmt->execute())
			{
				$data = array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_chalu_nave;
					$data[1]	=	$res_chalu_jama;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_aajche_nave_kalyan($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `aajche_nave` from `finance_manager` where `agent_id` = ? AND `saved_date`=? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	function get_aajche_nave_mumbai($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `aajche_nave_mumbai` from `finance_manager` where `agent_id` = ? AND `saved_date`=? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	function get_user_last_transaction_data($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `aajche_jama_mumbai`, `aajche_nave_mumbai`, `aajche_nave`, `aajche_jama`, `chalu_nave`, `chalu_jama`,`saved_date`, `farak_dhanda`, `farak_jama`, `vasuli`, `vatap`  FROM `finance_manager` WHERE  `agent_id` = ? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("s",$agent_id);

			$stmt->bind_result($id,$res_agent_id,$aajche_jama_mumbai,$aajche_nave_mumbai,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$saved_date,$farak_dhanda,$farak_jama,$vasuli,$vatap);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$id;
					$data[1]	=	$res_agent_id;
					$data[2]	=	$aajche_jama_mumbai;
					$data[3]	=	$aajche_nave_mumbai;
					$data[4]	=	$aajche_nave;
					$data[5]	=	$aajche_jama;
					$data[6]	=	$chalu_nave;
					$data[7]	=	$chalu_jama;
					$data[8]	=	$saved_date;
					$data[9]	=	$farak_dhanda;
					$data[10]	=	$farak_jama;
					$data[11]	=	$vasuli;
					$data[12]	=	$vatap;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_aajche_jama_kalyan($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `aajche_jama` from `finance_manager` where `agent_id` = ? AND `saved_date`=? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	function get_aajche_jama_mumbai($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
				
		if($stmt = $this->con->prepare("Select `aajche_jama_mumbai` from `finance_manager` where `agent_id` = ? AND `saved_date`=? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	
	function get_magil_jama($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `chalu_jama` from `finance_manager` where `agent_id` = ? AND `saved_date`!=? AND `saved_date` < ? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("sss",$agent_res_id,$search_date,$search_date);

			$stmt->bind_result($magil_jama);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $magil_jama;
				}
			}
			return false;
		}
	}
	
	function check_rojnama_data_exist($agent_res_id,$search_date,$search_market)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `id` from `agent_rojnama_data` where `agent_id` = ? AND `saved_date` = ? AND `business_main_title` = ?"))
		{
			$stmt->bind_param("sss",$agent_res_id,$search_date,$search_market);

			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function get_payment_data_exist($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `id` from `finance_manager` where `agent_id` = ? AND `saved_date` = ?"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function get_total_transaction_data($agent_id,$search_date,$buisness_main_title)
	{
		
	$date_data	=	explode("-",$search_date);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
				
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `business_main_title`, `dhanda`, `payment`, `saved_date`, `o_thok`, `o_chillar`, `b_thok`, `b_chillar`, `c_thok`, `c_chillar`, `op_thok`, `op_chillar`, `op_t55`, `cp_thok`, `cp_chillar`, `cp_t55`, `date`, `time` FROM `agent_rojnama_data` WHERE `agent_id` =? AND `business_main_title` = ? AND `saved_date`=?"))
		{
			$stmt->bind_param("sss",$agent_id,$buisness_main_title,$search_date);

			$stmt->bind_result($id,$agent_id,$business_main_title,$dhanda,$payment,$saved_date,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$id;
					$data[1]	=	$agent_id;
					$data[2]	=	$business_main_title;
					$data[3]	=	$dhanda;
					$data[4]	=	$payment;
					$data[5]	=	$saved_date;
					$data[8]	=	$o_thok;
					$data[9]	=	$o_chillar;
					$data[10]	=	$b_thok;
					$data[11]	=	$b_chillar;
					$data[12]	=	$c_thok;
					$data[13]	=	$c_chillar;
					$data[14]	=	$op_thok;
					$data[15]	=	$op_chillar;
					$data[16]	=	$op_t55;
					$data[17]	=	$cp_thok;
					$data[18]	=	$cp_chillar;
					$data[19]	=	$cp_t55;
					$data[20]	=	$date;
					$data[21]	=	$time;
					
					return $data;
				}
			}
			return false;
		}
	}
	function get_total_transaction_data1($agent_id,$search_date,$buisness_main_title)
	{
		
	$date_data	=	explode("-",$search_date);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
				
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `business_main_title`, `dhanda`, `payment`, `saved_date`, `o_thok`, `o_chillar`, `b_thok`, `b_chillar`, `c_thok`, `c_chillar`, `op_thok`, `op_chillar`, `op_t55`, `cp_thok`, `cp_chillar`, `cp_t55`, `date`, `time` FROM `agent_rojnama_data` WHERE `agent_id` =? AND `business_main_title` = ? AND `saved_date`=?"))
		{
			$stmt->bind_param("sss",$agent_id,$buisness_main_title,$search_date);

			$stmt->bind_result($id,$agent_id,$business_main_title,$dhanda,$payment,$saved_date,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$id;
					$data[1]	=	$agent_id;
					$data[2]	=	$business_main_title;
					$data[3]	=	$dhanda;
					$data[4]	=	$payment;
					$data[5]	=	$saved_date;
					$data[8]	=	$o_thok;
					$data[9]	=	$o_chillar;
					$data[10]	=	$b_thok;
					$data[11]	=	$b_chillar;
					$data[12]	=	$c_thok;
					$data[13]	=	$c_chillar;
					$data[14]	=	$op_thok;
					$data[15]	=	$op_chillar;
					$data[16]	=	$op_t55;
					$data[17]	=	$cp_thok;
					$data[18]	=	$cp_chillar;
					$data[19]	=	$cp_t55;
					$data[20]	=	$date;
					$data[21]	=	$time;
					
					return $data;
				}
			}
			return false;
		}
	}
	function check_todays_rojnama_mgmt_exist($search_date,$search_market)
	{
		if($stmt = $this->con->prepare("Select `id` from `rojnama_buisness_mgmt` where `saved_date` = ? AND `business_main_title` = ?"))
		{
			$stmt->bind_param("ss",$search_date,$search_market);

			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function get_complete_dhanda_of_agent_from_complete_db($agent_id)
	{
		if($stmt = $this->con->prepare("Select SUM(`dhanda`),SUM(`payment`) from `agent_rojnama_data` where `agent_id` = ?"))
		{
			$stmt->bind_param("s",$agent_id);

			$stmt->bind_result($res_sum_dhanda,$res_sum_payments);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data['dhanda']		=	$res_sum_dhanda;
					$data['payments']	=	$res_sum_payments;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_total_vasuli_vatap_from_agent($agent_id)
	{
		if($stmt = $this->con->prepare("Select SUM(`jama_paise`),SUM(`vatap_paise`) from `vasulti_vatap` where `agent_id` = ?"))
		{
			$stmt->bind_param("s",$agent_id);

			$stmt->bind_result($res_sum_jama,$res_sum_vatap);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data['jama']	=	$res_sum_jama;
					$data['vatap']	=	$res_sum_vatap;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_agent_name_from_id($agent_id)
	{
		
		if($stmt = $this->con->prepare("Select `name` from `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);

			$stmt->bind_result($res_name);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_name;
				}
			}
			return false;
		}
	}
	
	function get_agent_password_for_edit($user_id,$agent_id)
	{
		if($stmt = $this->con->prepare("Select `password` from `agent` where `user_id` = ? AND `id`!=?"))
		{
			$stmt->bind_param("si",$user_id,$agent_id);

			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
			}
			return false;
		}
	}
	
	function get_agents_data()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `user_id`, `password`, `date`, `time`,`agent_commission` FROM `agent`"))
		{
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time,$agent_commission);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$user_id;
					$data[$cntr][6]	=	$password;
					$data[$cntr][7]	=	$date;
					$data[$cntr][8]	=	$time;
					$data[$cntr][9]	=	$agent_commission;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_user_data()
	{
		if($stmt = $this->con->prepare("SELECT `user_id`, `vasuli_user_name` FROM `vasuli_user` "))
		{
			$stmt->bind_result($res_id,$vasuli_user_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$vasuli_user_name;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_agents_data_from_agent_id($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `oc_rate_chillar`, `oc_rate_thok`, `b_rate_chillar`, `b_rate_thok`, `p_rate_chillar`, `p_rate_thok`, `metro_rate_chillar`, `metro_rate_thok`, `parel_rate_chillar`, `parel_rate_thok`, `user_id`, `password`, `date`, `time`,`type`,`thok_rakkam` FROM `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$date,$time,$type,$thok_rakkam);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$oc_rate_chillar;
					$data[$cntr][6]	=	$oc_rate_thok;
					$data[$cntr][7]	=	$b_rate_chillar;
					$data[$cntr][8]	=	$b_rate_thok;
					$data[$cntr][9]	=	$p_rate_chillar;
					$data[$cntr][10]	=	$p_rate_thok;
					$data[$cntr][11]	=	$metro_rate_chillar;
					$data[$cntr][12]	=	$metro_rate_thok;
					$data[$cntr][13]	=	$parel_rate_chillar;
					$data[$cntr][14]	=	$parel_rate_thok;
					$data[$cntr][15]	=	$user_id;
					$data[$cntr][16]	=	$password;
					$data[$cntr][17]	=	$date;
					$data[$cntr][18]	=	$time;
					$data[$cntr][19]	=	$type;
					$data[$cntr][20]	=	$thok_rakkam;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_agent_data_from_id($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`,`user_id`, `password`, `date`, `time`,`jodi_commission`, `single_pana_commission`, `double_pana_commission`, `triple_pana_commissions`,`police_station`,`agent_commission`,`sangam_rate`,`chitthiwala` FROM `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time,$jodi_commission,$single_pana_commission,$double_pana_commission,$triple_pana_commission,$police_station,$agent_commission,$sangam_rate,$chitthiwala);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[4]	=	$commission;
					$data[5]	=	$user_id;
					$data[6]	=	$password;
					$data[7]	=	$date;
					$data[8]	=	$time;
					$data[9]	=	$jodi_commission;
					$data[10]	=	$single_pana_commission;
					$data[11]	=	$double_pana_commission;
					$data[12]	=	$triple_pana_commission;
					$data[13]	=	$police_station;
					$data[14]	=	$agent_commission;
					$data[15]	=	$sangam_rate;
					$data[16]	=	$chitthiwala;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function delete_agent($agent_id)
	{
		if($stmt = $this->con->prepare("Delete from `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_finance_manager_data($agent_id,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("DELETE FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=?"))
		{
			$stmt->bind_param("ss",$agent_id,$taarikh);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_rojnama_data($agent_id,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("DELETE FROM `agent_rojnama_data` WHERE `agent_id`=? AND `date`=?"))
		{
			$stmt->bind_param("ss",$agent_id,$taarikh);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_agent_aakde_data($agent_id,$taarikh,$buisness_main_title,$buisness_sub_title)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("DELETE FROM `agent_aakde` WHERE `agent`=? AND `buisness_main_title`=? AND `buisness_sub_title`=? AND `date`=?"))
		{
			$stmt->bind_param("ssss",$agent_id,$buisness_main_title,$buisness_sub_title,$taarikh);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function delete_agent_aakde_data1($count)
	{
	
		
		if($stmt = $this->con->prepare("DELETE FROM `agent_aakde` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$count);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_new_agent($agent_name,$address,$mobile_no,$commission,$agent_user_id,$password,$agent_id,$jodi_commission,$single_pana_commission,$double_pana_commission,$triple_pana_commission,$police_station,$agent_commission,$sangam_rate,$chitthiwala)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `agent` SET `name`=?,`address`=?,`mobile_no`=?,`commission`=?,`user_id`=?,`password`=?,`date`=?,`time`=?,`jodi_commission`=?,`single_pana_commission`=?,`double_pana_commission`=?,`triple_pana_commissions`=?,`police_station`=?,`agent_commission`=?,`sangam_rate`=?,`chitthiwala`=?  WHERE `id`=?"))
		{
			$stmt->bind_param("ssssssssssssssssi",$agent_name,$address,$mobile_no,$commission,$agent_user_id,$password,$date,$time,$jodi_commission,$single_pana_commission,$double_pana_commission,$triple_pana_commission,$police_station,$agent_commission,$sangam_rate,$chitthiwala,$agent_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_winner_aakda_val_exist($buisness_main_title,$buisness_sub_title,$aakda_date)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `winner_aakda` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `winner_date`=?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_id);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function get_cutting_aakda_val_exist($buisness_main_title,$buisness_sub_title,$aakda_date)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `cutting_aakde` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `tarikh`=?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_id);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function save_winner_aakda($buisness_main_title,$buisness_sub_title,$patta_val,$aakda_val,$aakda_date)
	{
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `winner_aakda`(`business_main_title`, `business_sub_title`, `patta`, `aakda`, `winner_date`, `date`, `time`) VALUES (?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssss",$buisness_main_title,$buisness_sub_title,$patta_val,$aakda_val,$aakda_date,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function insert_new_transaction_details($res_agent_id,$aajche_jama_mumbai,$aajche_nave_mumbai,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$taarikh,$farak_dhanda,$farak_jama,$vasuli,$vatap)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");

		if($stmt = $this->con->prepare("INSERT INTO `finance_manager`(`agent_id`, `aajche_jama_mumbai`, `aajche_nave_mumbai`, `aajche_nave`, `aajche_jama`, `chalu_nave`, `chalu_jama`, `saved_date`, `farak_dhanda`, `farak_jama`, `date`, `time`, `vasuli`, `vatap`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssssssss",$res_agent_id,$aajche_jama_mumbai,$aajche_nave_mumbai,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$taarikh,$farak_dhanda,$farak_jama,$date,$time,$vasuli,$vatap);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function insert_pay_todays($agent_res_id,$search_date,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$aajche_nave_mumbai,$aajche_jama_mumbai)
	{
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("INSERT INTO `finance_manager`(`agent_id`, `aajche_nave`, `aajche_jama`, `chalu_nave`, `chalu_jama`, `saved_date`, `date`, `time`,`aajche_nave_mumbai`,`aajche_jama_mumbai`) VALUES (?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssss",$agent_res_id,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$search_date,$date,$time,$aajche_nave_mumbai,$aajche_jama_mumbai);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_pay_todays($agent_res_id,$search_date,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$pay_exist_id,$aajche_nave_mumbai,$aajche_jama_mumbai)
	{
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Update `finance_manager` SET `aajche_nave` = ?, `aajche_jama`=?, `chalu_nave`=?, `chalu_jama`=?,`saved_date`=?,`aajche_nave_mumbai`=?,`aajche_jama_mumbai`=? Where `id`=?"))
		{
			$stmt->bind_param("sssssssi",$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$search_date,$aajche_nave_mumbai,$aajche_jama_mumbai,$pay_exist_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function insert_rojnama_data_for_agent($agent_res_id,$search_date,$dhanda,$search_market,$total_final_payment,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `agent_rojnama_data`(`agent_id`, `business_main_title`, `dhanda`, `payment`, `saved_date`, `o_thok`, `o_chillar`, `b_thok`, `b_chillar`, `c_thok`, `c_chillar`, `op_thok`, `op_chillar`, `op_t55`, `cp_thok`, `cp_chillar`, `cp_t55`, `date`, `time`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssssssssssssssss",$agent_res_id,$search_market,$dhanda,$total_final_payment,$search_date,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_rojnama_data_for_agent($agent_res_id,$search_date,$dhanda,$search_market,$total_final_payment,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$exist_id)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");

		if($stmt = $this->con->prepare("UPDATE `agent_rojnama_data` SET `agent_id`=?,`business_main_title`=?,`dhanda`=?,`payment`=?,`saved_date`=?,`o_thok`=?,`o_chillar`=?,`b_thok`=?,`b_chillar`=?,`c_thok`=?,`c_chillar`=?,`op_thok`=?,`op_chillar`=?,`op_t55`=?,`cp_thok`=?,`cp_chillar`=?,`cp_t55`=?,`date`=?,`time`=? WHERE `id`=?"))
		{
			$stmt->bind_param("sssssssssssssssssssi",$agent_res_id,$search_market,$dhanda,$total_final_payment,$search_date,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$date,$time,$exist_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function insert_rojnama_mgmt($open_utari,$close_utari,$total_utari,$open_passing,$close_passing,$total_passing,$search_date,$search_market)
	{
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `rojnama_buisness_mgmt`(`saved_date`, `open_uatri`, `open_passing`, `close_utari`, `close_passing`, `date`, `time`,`business_main_title`) VALUES (?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssss",$search_date,$open_utari,$open_passing,$close_utari,$close_passing,$date,$time,$search_market);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_rojnama_mgmt($open_utari,$close_utari,$total_utari,$open_passing,$close_passing,$total_passing,$search_date,$search_market)
	{
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `rojnama_buisness_mgmt` SET `saved_date`=?,`open_uatri`=?,`open_passing`=?,`close_utari`=?,`close_passing`=?,`date`=?,`time`=? WHERE `saved_date`=? AND `business_main_title` = ?"))
		{
			$stmt->bind_param("sssssssss",$search_date,$open_utari,$open_passing,$close_utari,$close_passing,$date,$time,$search_date,$search_market);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function save_agent_aakda($agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$date)
	{
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `agent_aakde`(`agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`) VALUES (?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssss",$agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function save_cutting_aakda($buisness_main_title,$buisness_sub_title,$metro_patta,$sadha_patta,$parel_patta,$tarikh,$cutting_type)
	{
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `cutting_aakde`(`tarikh`, `business_main_title`, `business_sub_title`, `metro_patta`, `sadha_patta`, `parel_patta`, `date`, `time`,`cutting_type`) VALUES (?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssssss",$tarikh,$buisness_main_title,$buisness_sub_title,$metro_patta,$sadha_patta,$parel_patta,$date,$time,$cutting_type);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_agent_aakda($agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$edit_aakda)
	{
		if($stmt = $this->con->prepare("UPDATE `agent_aakde` SET `agent`=?,`buisness_main_title`=?,`buisness_sub_title`=?,`aakda`=?,`paise`=?,`added_by`=? WHERE `id`=?"))
		{
			$stmt->bind_param("ssssssi",$agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$edit_aakda);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_last_paise_of_agent($agent_name)
	{
		$date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("Select `paise` from `agent_aakde` where `agent` = ? AND `date` = ? ORDER By `id` DESC"))
		{
			$stmt->bind_param("ss",$agent_name,$date);

			$stmt->bind_result($res_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_paise;
				}
			}
			return false;
		}
	}
	
	function get_farak_data($agent_id,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
				
		if($stmt = $this->con->prepare("SELECT `farak_dhanda`, `farak_jama` FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=? AND (`farak_dhanda` > 0 OR `farak_jama` > 0) ORDER BY `id` DESC"))
		{
			$stmt->bind_param("ss",$agent_id,$taarikh);

			$stmt->bind_result($res_farak_dhanda,$res_farak_jama);
			
			if($stmt->execute())
			{
				$data = array();
				
				if($stmt->fetch())
				{
					$data[0] = $res_farak_dhanda;
					$data[1] = $res_farak_jama;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	
	function get_mgmt_data_from_date($search_date,$search_market)
	{
		$date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("SELECT `id`, `saved_date`, `open_uatri`, `open_passing`, `close_utari`, `close_passing`, `date`, `time` FROM `rojnama_buisness_mgmt` WHERE `saved_date`=? AND `business_main_title` = ?"))
		{
			$stmt->bind_param("ss",$search_date,$search_market);

			$stmt->bind_result($res_id, $res_saved_date, $res_open_uatri, $res_open_passing, $res_close_utari,$res_close_passing,$res_date,$res_time);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$res_saved_date;
					$data[2]	=	$res_open_uatri;
					$data[3]	=	$res_open_passing;
					$data[4]	=	$res_close_utari;
					$data[5]	=	$res_close_passing;
					$data[6]	=	$res_date;
					$data[7]	=	$res_time;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	
	function get_winner_data_from_date($winner_date)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `business_main_title`, `business_sub_title`, `patta`, `aakda`, `winner_date`, `date`, `time` FROM `winner_aakda` WHERE `winner_date`=?"))
		{
			$stmt->bind_param("s",$winner_date);

			$stmt->bind_result($id,$business_main_title,$business_sub_title,$patta,$aakda,$winner_date,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$business_main_title;
					$data[$cntr][2]	=	$business_sub_title;
					$data[$cntr][3]	=	$patta;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$winner_date;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_cutting_data_from_date($crt_date)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `tarikh`, `business_main_title`, `business_sub_title`, `metro_patta`, `sadha_patta`, `parel_patta`, `date`, `time`,`cutting_type` FROM `cutting_aakde` WHERE `tarikh`=?"))
		{
			$stmt->bind_param("s",$crt_date);

			$stmt->bind_result($id,$tarikh, $business_main_title, $business_sub_title, $metro_patta, $sadha_patta, $parel_patta, $date, $time,$cutting_type);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$tarikh;
					$data[$cntr][2]	=	$business_main_title;
					$data[$cntr][3]	=	$business_sub_title;
					$data[$cntr][4]	=	$metro_patta;
					$data[$cntr][5]	=	$sadha_patta;
					$data[$cntr][6]	=	$parel_patta;
					$data[$cntr][7]	=	$date;
					$data[$cntr][8]	=	$time;
					$data[$cntr][9]	=	$cutting_type;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_todays_aakde_data()
	{
		
		
		$todays_date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `date`=? ORDER by `id` DESC"))
		{
			$stmt->bind_param("s",$todays_date);

			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_aakde_data_from_search($agent_id,$taarikh,$aakda,$buisness_main_title,$buisness_sub_title)
	{
		$stmt = "";
		if($agent_id=="All")
		{
			$agent_id	=	"";
			$stmt = " AND `agent` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent`='".$agent_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
		if($aakda!="")
		{
			$stmt = $stmt." AND `aakda` = '".$aakda."' ";
		}
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`,`type`,`total_amount` FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt." ORDER BY `id` ASC "))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by,$type,$total_amount);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					$data[$cntr][9]	=	$type;
					$data[$cntr][10]=	$total_amount;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_open_close_dhanda_for_rojnama($agent_id,$taarikh,$buisness_main_title,$buisness_sub_title)
	{
		$stmt = "";
		if($agent_id=="सर्व दाखवा")
		{
			$agent_id	=	"";
			$stmt = " AND `agent` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent`='".$agent_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt))
		{
			$stmt->bind_result($paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $paise;
				}
			}
			return false;
		}
	}
	
	function get_aakde_data_from_id($edit_aakda)
	{
		$todays_date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$edit_aakda);

			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function delete_winner_aakda($win_del_id)
	{
		if($stmt = $this->con->prepare("Delete from `winner_aakda` where `id` = ?"))
		{
			$stmt->bind_param("i",$win_del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_cutting_aakda($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `cutting_aakde` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_agent_aakda($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `agent_aakde` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_sadha_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999') AND `aakda` NOT LIKE '%00%' AND `aakda` NOT LIKE '%11%' AND `aakda` NOT LIKE '%22%' AND `aakda` NOT LIKE '%33%' AND `aakda` NOT LIKE '%44%' AND `aakda` NOT LIKE '%55%' AND `aakda` NOT LIKE '%66%' AND `aakda` NOT LIKE '%77%' AND `aakda` NOT LIKE '%88%' AND `aakda` NOT LIKE '%99%' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."'"))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_sadha_unique_aakde($searched_date,$buisness_main_title,$buisness_sub_title,$search_number)
	{	
		if($stmt = $this->con->prepare("SELECT DISTINCT (`aakda`) FROM `agent_aakde` WHERE CHAR_LENGTH(`aakda`)=3 AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999') AND `aakda` NOT LIKE '%00%' AND `aakda` NOT LIKE '%11%' AND `aakda` NOT LIKE '%22%' AND `aakda` NOT LIKE '%33%' AND `aakda` NOT LIKE '%44%' AND `aakda` NOT LIKE '%55%' AND `aakda` NOT LIKE '%66%' AND `aakda` NOT LIKE '%77%' AND `aakda` NOT LIKE '%88%' AND `aakda` NOT LIKE '%99%' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` LIKE '%".$search_number."%'"))
		{
			$stmt->bind_result($aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_sadha_aakde_for_sending($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`aakda` FROM `agent_aakde` WHERE CHAR_LENGTH(`aakda`)=3 AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999') AND `aakda` NOT LIKE '%00%' AND `aakda` NOT LIKE '%11%' AND `aakda` NOT LIKE '%22%' AND `aakda` NOT LIKE '%33%' AND `aakda` NOT LIKE '%44%' AND `aakda` NOT LIKE '%55%' AND `aakda` NOT LIKE '%66%' AND `aakda` NOT LIKE '%77%' AND `aakda` NOT LIKE '%88%' AND `aakda` NOT LIKE '%99%' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."'"))
		{
			$stmt->bind_result($res_id,$aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_metro_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND (`aakda` LIKE '%00%' OR `aakda` LIKE '%11%' OR `aakda` LIKE '%22%' OR `aakda`  LIKE '%33%' OR `aakda`  LIKE '%44%' OR `aakda`  LIKE '%55%' OR `aakda`  LIKE '%66%' OR `aakda`  LIKE '%77%' OR `aakda`  LIKE '%88%' OR `aakda`  LIKE '%99%') AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
    function get_metro_unique_aakde($searched_date,$buisness_main_title,$buisness_sub_title,$search_number)
	{
		if($stmt = $this->con->prepare("SELECT DISTINCT(`aakda`) FROM `agent_aakde` WHERE  CHAR_LENGTH(`aakda`)=3 AND (`aakda` LIKE '%00%' OR `aakda` LIKE '%11%' OR `aakda` LIKE '%22%' OR `aakda`  LIKE '%33%' OR `aakda`  LIKE '%44%' OR `aakda`  LIKE '%55%' OR `aakda`  LIKE '%66%' OR `aakda`  LIKE '%77%' OR `aakda`  LIKE '%88%' OR `aakda`  LIKE '%99%') AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` LIKE '%".$search_number."%' AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_metro_aakde_for_sending($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`aakda` FROM `agent_aakde` WHERE  CHAR_LENGTH(`aakda`)=3 AND (`aakda` LIKE '%00%' OR `aakda` LIKE '%11%' OR `aakda` LIKE '%22%' OR `aakda`  LIKE '%33%' OR `aakda`  LIKE '%44%' OR `aakda`  LIKE '%55%' OR `aakda`  LIKE '%66%' OR `aakda`  LIKE '%77%' OR `aakda`  LIKE '%88%' OR `aakda`  LIKE '%99%') AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($res_id,$aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_parel_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_parel_unique_aakde($searched_date,$buisness_main_title,$buisness_sub_title,$search_number)
	{
		if($stmt = $this->con->prepare("SELECT DISTINCT(`aakda`) FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` LIKE '%".$search_number."%' AND `aakda` IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_parel_aakde_for_sending($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`aakda` FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($res_id,$aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_sum_of_aakda($searched_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `aakda` = '".$patta."' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `sent`=''"))
		{
			$stmt->bind_result($total_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $total_paise;
				}
			}
			return false;
		}
	}
	
	function get_sum_of_amount_not_cutted($res_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT `not_cutted_values` FROM `shillak_rakkam` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=? AND `patta`=?"))
		{
			$stmt->bind_param("ssss",$res_date,$buisness_main_title,$buisness_sub_title,$patta);
			
			$stmt->bind_result($r_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $r_paise;
				}
			}
			return false;
		}
	}
	
	
	function get_malkala_gelele_amount($searched_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT `malkala_gelele_paise` FROM `shillak_rakkam` WHERE `patta` = '".$patta."' AND `business_main_title` LIKE '%".$buisness_main_title."%' AND `business_sub_title` LIKE '%".$buisness_sub_title."%' AND `tarikh`='".$searched_date."'"))
		{
			$stmt->bind_result($total_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $total_paise;
				}
			}
			return false;
		}
	}
	
	function get_sum_of_aakda_in_utari($searched_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `aakda` = '".$patta."' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."'"))
		{
			$stmt->bind_result($total_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $total_paise;
				}
			}
			return false;
		}
	}
	
	function get_sadha_set_value($tarikh,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `sadha_patta` FROM `cutting_aakde` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=?"))
		{
			$stmt->bind_param("sss",$tarikh,$buisness_main_title,$buisness_sub_title);
			
			$stmt->bind_result($res_sadha_patta);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $res_sadha_patta;
				}
			}
			return false;
		}
	}
	
	function get_metro_set_value($tarikh,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `metro_patta` FROM `cutting_aakde` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=?"))
		{
			$stmt->bind_param("sss",$tarikh,$buisness_main_title,$buisness_sub_title);
			
			$stmt->bind_result($res_patta);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $res_patta;
				}
			}
			return false;
		}
	}
	
	function get_parel_set_value($tarikh,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `parel_patta` FROM `cutting_aakde` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=?"))
		{
			$stmt->bind_param("sss",$tarikh,$buisness_main_title,$buisness_sub_title);
			
			$stmt->bind_result($res_patta);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $res_patta;
				}
			}
			return false;
		}
	}
	
	function get_open_load_sheet_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda`=?  AND CHAR_LENGTH(`aakda`)=1 AND `type`='none' "))
		{
			
			$stmt->bind_param("s",$passed_val);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_open_load_sheet_data_jodi($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda`=?  AND CHAR_LENGTH(`aakda`)=2"))
		{
			
			$stmt->bind_param("s",$passed_val);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_open_load_sheet_data_pana($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda`=?  AND CHAR_LENGTH(`aakda`)=3"))
		{
			
			$stmt->bind_param("s",$passed_val);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function delete_todays_aakde_data()
	{
		if($stmt = $this->con->prepare("Delete from `agent_aakde`"))
		{
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_winner_aakda($aakda_date,$buisness_main_title,$buisness_sub_title)
	{
		$date_data	=	explode("-",$aakda_date);
		$aakda_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `aakda` FROM `winner_aakda` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `winner_date`=?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_aakda);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{	
					return $res_aakda;
				}
			}
			return false;
		}
	}
	function get_winner_aakda_open($aakda_date,$buisness_main_title,$buisness_sub_title)
	{
		$buisness_sub_title="OPEN";
		$date_data	=	explode("-",$aakda_date);
		
		$aakda_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		
		if($stmt = $this->con->prepare("SELECT `aakda` FROM `winner_aakda` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `winner_date`=?"))
		{
			
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_aakda);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{	
					return $res_aakda;
				}
			}
			return false;
		}
	}
	function get_winner_patta($aakda_date,$buisness_main_title,$buisness_sub_title)
	{
		
		$date_data	=	explode("-",$aakda_date);
		
		$aakda_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `patta` FROM `winner_aakda` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `winner_date`=?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_aakda);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_aakda;
				}
			}
			return false;
		}
	}
	
	function get_close_load_sheet_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` =? AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND CHAR_LENGTH(`aakda`)=2"))
		{
				$stmt->bind_param("s",$buisness_main_title);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_thok_value($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_all_o_thok_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_o_chillar_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_thok_value_for_bracket($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	
	function get_all_b_thok_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_b_chillar_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_thok_value_for_patta($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_all_oc_patta_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_c_thok_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_c_chillar_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_thok_value_for_chillar($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_chillar_value_for_bracket($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_chillar_value($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_close_load_sheet_data_for_close_numbers($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title`=? AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` LIKE '".$passed_val."' AND CHAR_LENGTH(`aakda`)=1 AND `type`='none' "))
		{
			$stmt->bind_param("s",$buisness_main_title);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_cutting_setting()
	{
		if($stmt = $this->con->prepare("Select `setting` from `cutting_setting`"))
		{
			$stmt->bind_result($setting);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $setting;
				}
			}
			return false;
		}
	}
	
	function get_set_cutting($res_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("Select `cutting_type` from `cutting_aakde` where `business_main_title` = ? AND `business_sub_title` = ? AND `tarikh` = ?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$res_date);
			
			$stmt->bind_result($cutting_type);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $cutting_type;
				}
			}
			return false;
		}
	}
	
	function update_cutting_setting($setting)
	{
		if($stmt = $this->con->prepare("Update `cutting_setting` SET `setting` = ?"))
		{
			$stmt->bind_param("s",$setting);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_completed_commission($res_date,$buisness_main_title,$buisness_sub_title,$sadha_patta)
	{
		if($stmt = $this->con->prepare("UPDATE `shillak_rakkam` SET `not_cutted_values`=0 WHERE `tarikh` = ? AND `business_main_title` = ? AND `business_sub_title`=? AND `patta`=?"))
		{
			$stmt->bind_param("ssss",$res_date,$buisness_main_title,$buisness_sub_title,$sadha_patta);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}

	function save_todays_draw_commission($res_date,$buisness_main_title,$buisness_sub_title,$patta,$set_metro_val)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `saved_commission`(`buisness_main_title`, `buisness_sub_title`, `tarikh`, `patta`, `completed_commission`, `date`, `time`) VALUES (?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssss",$buisness_main_title,$buisness_sub_title,$res_date,$patta,$set_metro_val,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
		}
		return false;
	}
	
	function save_shillak_of_akda($res_date,$buisness_main_title,$buisness_sub_title,$patta,$paise,$cutting_type,$malkala_gelele_total,$without_sadha_rahilele)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `shillak_rakkam`(`tarikh`, `business_main_title`, `business_sub_title`, `patta`, `shillak_paise`, `cutting_type`, `date`, `time`,`malkala_gelele_paise`,`not_cutted_values`) VALUES (?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssss",$res_date,$buisness_main_title,$buisness_sub_title,$patta,$paise,$cutting_type,$date,$time,$malkala_gelele_total,$without_sadha_rahilele);
			
			if($stmt->execute())
			{
				return true;
			}
		}
		return false;
	}
	
	function get_commission_value_alredy_saved($res_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `saved_commission` WHERE `buisness_main_title`=? AND `buisness_sub_title`=? AND `tarikh`=? AND `patta`=?"))
		{
			$stmt->bind_param("ssss",$buisness_main_title,$buisness_sub_title,$res_date,$patta);
			
			$stmt->bind_result($r_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $r_id;
				}
			}
			return false;
		}
	}
	
	function get_shillak_patta_value_alredy_saved($res_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT `shillak_paise` FROM `shillak_rakkam` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=? AND `patta`=?"))
		{
			$stmt->bind_param("ssss",$res_date,$buisness_main_title,$buisness_sub_title,$patta);
			
			$stmt->bind_result($r_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $r_paise;
				}
			}
			return false;
		}
	}
	
	function update_shillak_of_akda($res_date,$buisness_main_title,$buisness_sub_title,$patta,$shillak,$cutting_type,$malkala_gelele_total,$without_sadha_rahilele)
	{
		if($stmt = $this->con->prepare("UPDATE `shillak_rakkam` SET `shillak_paise`=?,`malkala_gelele_paise`=?,`not_cutted_values`=? Where `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=? AND `patta`=? AND `cutting_type`=?"))
		{
			$stmt->bind_param("ssssssss",$shillak,$malkala_gelele_total,$without_sadha_rahilele,$res_date,$buisness_main_title,$buisness_sub_title,$patta,$cutting_type);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function generateRandomString($length = 10) {
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;
	}
	
	function set_numbers_sent($transaction_id,$sent_id_data)
	{
		if($stmt = $this->con->prepare("UPDATE `agent_aakde` SET `sent`='1',`transaction_id`='".$transaction_id."' WHERE `id` IN (".$sent_id_data.")"))
		{
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function register_new_user($su_full_name,$su_mobile_no,$su_address,$su_agent,$su_new_agent,$su_save_agent,$su_page_load,$su_cutting,$su_cutting_report,$su_orignal_load,$su_utari_cutting,$su_number,$su_enter_number,$su_save_number,$su_delete_number,$su_rojnama,$su_rk,$su_rm,$su_winner_no,$su_winner_e,$su_winner_save,$su_vasuli,$su_today_winner,$su_vasuli_v,$su_taka,$su_report,$su_find_no,$su_close,$su_ck,$su_cm,$su_open,$su_ok,$su_om,$su_user_id,$su_password,$su_pwd_update,$su_software,$su_setting,$su_new,$su_view,$su_staff,$su_staff_new,$su_staff_view,$su_offlinestaff,$su_offstaff_new,$su_offstaff_view,$su_market_set)
	{
	
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `user`(`agent`, `new_agent`, `save_agent`, `page_load`, `cutting`, `cutting_report`, `orignal_load`, `utari_cutting`, `number`, `enter_number`, `save_number`, `delete_number`, `rojnama`, `rk`, `rm`, `winner_no`, `winner_e`, `winner_save`, `vasuli`, `today_winner`, `vasuli_v`, `taka`, `report`, `find_no`, `close`, `ck`, `cm`, `open`, `ok`, `om`, `name`, `address`, `mobile_no`, `date`, `time`, `user_id`, `password`, `change_password`, `software`, `setting`, `add_user`, `view_user`, `staff`, `new_staff`, `view_staff`, `offline_staff`, `offstaff_new`, `offstaff_view`, `market_setting`)VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			
			$stmt->bind_param("sssssssssssssssssssssssssssssssssssssssssssssssss",$su_agent,$su_new_agent,$su_save_agent,$su_page_load,$su_cutting,$su_cutting_report,$su_orignal_load,$su_utari_cutting,$su_number,$su_enter_number,$su_save_number,$su_delete_number,$su_rojnama,$su_rk,$su_rm,$su_winner_no,$su_winner_e,$su_winner_save,$su_vasuli,$su_today_winner,$su_vasuli_v,$su_taka,$su_report,$su_find_no,$su_close,$su_ck,$su_cm,$su_open,$su_ok,$su_om,$su_full_name,$su_address,$su_mobile_no,$date,$time,$su_user_id,$su_password,$su_pwd_update,$su_software,$su_setting,$su_new,$su_view,$su_staff,$su_staff_new,$su_staff_view,$su_offlinestaff,$su_offstaff_new,$su_offstaff_view,$su_market_set);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_user($delet_id)
	{
		if($stmt = $this->con->prepare("Delete from `user` where `id` = ?"))
		{
			$stmt->bind_param("i",$delet_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_user_data_from_id($user_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`agent`, `new_agent`, `save_agent`, `page_load`, `cutting`, `cutting_report`, `orignal_load`, `utari_cutting`, `number`, `enter_number`, `save_number`, `rojnama`, `rk`, `rm`, `winner_no`, `winner_e`, `winner_save`, `vasuli`, `today_winner`, `vasuli_v`, `taka`, `report`, `find_no`, `close`, `ck`, `cm`, `open`, `ok`, `om`, `name`, `address`, `mobile_no`,`user_id`,`password`,`software`,`setting`,`add_user`,`view_user` FROM `user` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$user_id);
			
			$stmt->bind_result($res_id,$agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$full_name,$address,$mobile_no,$user_id1,$password,$software,$setting,$new,$view);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent;
					$data[2]	=	$new_agent;
					$data[3]	=	$save_agent;
					$data[4]	=	$page_load;
					$data[5]	=	$cutting;
					$data[6]	=	$cutting_report;
					$data[7]	=	$orignal_load;
					$data[8]	=	$utari_cutting;
					$data[9]	=	$number;
					$data[10]	=	$enter_number;
					$data[11]	=	$save_number;
					$data[12]	=	$rojnama;
					$data[13]	=	$rk;
					$data[14]	=	$rm;
					$data[15]	=	$winner_no;
					$data[16]	=	$winner_e;
					$data[17]	=	$winner_save;
					$data[18]	=	$vasuli;
					$data[19]	=	$today_winner;
					$data[20]	=	$vasuli_v;
					$data[21]	=	$taka;
					$data[22]	=	$report;
					$data[23]	=	$find_no;
					$data[24]	=	$close;
					$data[25]	=	$ck;
					$data[26]	=	$cm;
					$data[27]	=	$open;
					$data[28]	=	$ok;
					$data[29]	=	$om;
					$data[30]	=	$full_name;
					$data[31]	=	$address;
					$data[32]	=	$mobile_no;
					$data[33]	=	$user_id1;
					$data[34]	=	$password;
					$data[35]	=	$software;
					$data[36]	=	$setting;
					$data[37]	=	$new;
					$data[38]	=	$view;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function update_user_record($agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$full_name,$address,$mobile_no,$user_id1,$password,$software,$setting,$new,$view,$user_id)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `user` SET `agent`=?,`new_agent`=?,`save_agent`=?,`page_load`=?,`cutting`=?,`cutting_report`=?,`orignal_load`=?,`utari_cutting`=?,`number`=?,`enter_number`=?,`save_number`=?,`rojnama`=?,`rk`=?,`rm`=?,`winner_no`=?,`winner_e`=?,`winner_save`=?,`vasuli`=?,`today_winner`=?,`vasuli_v`=?,`taka`=?,`report`=?,`find_no`=?,`close`=?,`ck`=?,`cm`=?,`open`=?,`ok`=?,`om`=?,`name`=?,`address`=?,`mobile_no`=?,`user_id`=?, `password`=?,`software`=?,`setting`=?,`add_user`=?,`view_user`=? WHERE `id`=?"))
		{
			$stmt->bind_param("ssssssssssssssssssssssssssssssssssssssi",$agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$full_name,$address,$mobile_no,$user_id1,$password,$software,$setting,$new,$view,$user_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_user_password($email)
		{
			if($stmt = $this->con->prepare("SELECT `password` FROM `user` WHERE `user_id` = ?"))
			{
				$stmt->bind_param("s",$email);
				
				$stmt->bind_result($res_password);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_password;
					}
					return False;
				}
			}
		}
	
	function get_user_status($user_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`agent`, `new_agent`, `save_agent`, `page_load`, `cutting`, `cutting_report`, `orignal_load`, `utari_cutting`, `number`, `enter_number`, `save_number`,`delete_number`, `rojnama`, `rk`, `rm`, `winner_no`, `winner_e`, `winner_save`, `vasuli`, `today_winner`, `vasuli_v`, `taka`, `report`, `find_no`, `close`, `ck`, `cm`, `open`, `ok`, `om`,`software`,`setting`,`add_user`,`view_user`,`staff`, `new_staff`, `view_staff`, `offline_staff`, `offstaff_new`, `offstaff_view`,`market_setting`, `change_password` FROM `user` WHERE `user_id`=?"))
		{
			$stmt->bind_param("s",$user_id);
			
			$stmt->bind_result($res_id,$agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$delete_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$software,$setting,$new,$view,$staff,$staffnew,$staffview,$offline_staff,$offstaffnew,$offstaffview,$market_setting,$pwdupd);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent;
					$data[2]	=	$new_agent;
					$data[3]	=	$save_agent;
					$data[4]	=	$page_load;
					$data[5]	=	$cutting;
					$data[6]	=	$cutting_report;
					$data[7]	=	$orignal_load;
					$data[8]	=	$utari_cutting;
					$data[9]	=	$number;
					$data[10]	=	$enter_number;
					$data[11]	=	$save_number;
					$data[12]	=	$delete_number;
					$data[13]	=	$rojnama;
					$data[14]	=	$rk;
					$data[15]	=	$rm;
					$data[16]	=	$winner_no;
					$data[17]	=	$winner_e;
					$data[18]	=	$winner_save;
					$data[19]	=	$vasuli;
					$data[20]	=	$today_winner;
					$data[21]	=	$vasuli_v;
					$data[22]	=	$taka;
					$data[23]	=	$report;
					$data[24]	=	$find_no;
					$data[25]	=	$close;
					$data[26]	=	$ck;
					$data[27]	=	$cm;
					$data[28]	=	$open;
					$data[29]	=	$ok;
					$data[30]	=	$om;
					$data[31]	=	$software;
					$data[32]	=	$setting;
					$data[33]	=	$new;
					$data[34]	=	$view;
					$data[35]	=	$staff;
					$data[36]	= 	$staffnew;
					$data[37] 	=	$staffview;
					$data[38] 	= 	$offline_staff;
					$data[39] 	= 	$offstaffnew;
					$data[40]	= 	$offstaffview;
					$data[41]	= 	$market_setting;
					$data[42]	=	$pwdupd;
					return $data;
				}
			}
			return false;
		}
	}
	function update_user_new_password($new_password,$email)
	{
		
		if($stmt = $this->con->prepare("UPDATE `admin` SET `password`=? WHERE `user_id`=?"))
		{
			$stmt->bind_param("ss",$new_password,$email);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function update_vasuliuser_new_password($new_password,$email)
	{
		
		if($stmt = $this->con->prepare("UPDATE `vasuli_user` SET `password`=? WHERE `user_id`=?"))
		{
			$stmt->bind_param("ss",$new_password,$email);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_offline_user_password($email)
	{
		if($stmt = $this->con->prepare("SELECT `password` FROM `offline-staff` WHERE `user_id` = ?"))
		{
			$stmt->bind_param("s",$email);
			
			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
				return False;
			}
		}
	}
	
	function get_user_status_block_active($email)
	{
		if($stmt = $this->con->prepare("SELECT `status` FROM `offline-staff` WHERE `user_id` = ?"))
		{
			$stmt->bind_param("s",$email);
			
			$stmt->bind_result($res_status);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_status;
				}
				return False;
			}
		}
	}
	
	function get_agent_id($userid)
	{
		if($stmt = $this->con->prepare("SELECT A.`id`, A.`name` FROM `agent` AS A INNER JOIN `staff_added_agent` AS B ON A.`id`=B.`agent_name` WHERE B.`staff_id`=?"))
		{
			$stmt->bind_param("s",$userid);
			$stmt->bind_result($res_id,$agent_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function check_random_stringexist($random_string)
	{
		
		if($stmt = $this->con->prepare("SELECT `id` FROM `agent_aakde` WHERE `random_string`=?"))
		{
			$stmt->bind_param("s",$random_string);

			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
    function save_agent_aakda_from_offline_entry($sel_agent,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$date,$random_string,$time,$type,$total_amount)
	{
		//$time = date("h:i:s A");
		$transaction_id="";
		$customer_id   ="";
	    $sent           ="";
		if($stmt = $this->con->prepare("INSERT INTO `agent_aakde`(`agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`,`random_string`,`transaction_id`,`customer_id`,`type`,`sent`,`total_amount`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssssssss",$sel_agent,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$date,$time,$added_by,$random_string,$transaction_id,$customer_id,$type,$sent,$total_amount);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function save_agent_aakda_from_offline_entry_new_function($query_sentense)
	{
		$transaction_id="";
		$customer_id   ="";
	    $sent           ="";
		if($stmt = $this->con->prepare("INSERT INTO `agent_aakde`(`agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`,`random_string`,`transaction_id`,`customer_id`,`type`,`sent`,`total_amount`) VALUES".$query_sentense))
		{
			//$stmt->bind_param("ssssssssssssss",$sel_agent,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$date,$time,$added_by,$random_string,$transaction_id,$customer_id,$type,$sent,$total_amount);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_staff_password($su_user_id)
	{
		if($stmt = $this->con->prepare("SELECT `password` FROM `offline-staff` WHERE `user_id`=?"))
		{
			$stmt->bind_param("s",$su_user_id);
			
			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
				return False;
			}
		}
	}
	function register_new_offline_user($su_full_name,$su_mobile_no,$su_address,$su_user_id,$su_password)
	{
		$status	=	"active";
		$date 	= date("Y-m-d");
		$time 	= date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `offline-staff`(`name`, `address`, `mobile_no`, `user_id`, `password`, `status`, `date`, `time`) VALUES (?,?,?,?,?,?,?,?)"))
		{
			
			$stmt->bind_param("ssssssss",$su_full_name,$su_address,$su_mobile_no,$su_user_id,$su_password,$status,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function delete_offline_staff($delet_id)
	{
		if($stmt = $this->con->prepare("Delete from `offline-staff` where `id` = ?"))
		{
			$stmt->bind_param("i",$delet_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_offline_staff_data()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `user_id`, `password`, `status`  FROM `offline-staff`"))
		{
			$stmt->bind_result($res_id,$full_name,$address,$mobile_no,$user_id,$password,$status);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$full_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$user_id;
					$data[$cntr][5]	=	$password;
					$data[$cntr][6]	=	$status;
					
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_offline_staff_data_from_id($user_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `user_id`, `password` FROM `offline-staff` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$user_id);
			
			$stmt->bind_result($res_id,$full_name,$address,$mobile_no,$user_id1,$password);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$full_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[4]	=	$user_id1;
					$data[5]	=	$password;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function update_offline_staff_record($full_name,$address,$mobile_no,$user_id1,$password,$user_id)
	{
		
		if($stmt = $this->con->prepare("UPDATE `offline-staff` SET `name`=?,`address`=?,`mobile_no`=?,`user_id`=?,`password`=? WHERE `id`=?"))
		{
			$stmt->bind_param("sssssi",$full_name,$address,$mobile_no,$user_id1,$password,$user_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function update_staff_status($status,$active_id)
	{
		
		if($stmt = $this->con->prepare("UPDATE `offline-staff` SET `status`=? WHERE `id`=?"))
		{
			$stmt->bind_param("si",$status,$active_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function add_new_agent($staff_user_id,$current_agent)
	{
		$date 	= date("Y-m-d");
		$time 	= date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `staff_added_agent`(`staff_id`, `agent_name`, `date`, `time`) VALUES(?,?,?,?)"))
		{
			$stmt->bind_param("ssss",$staff_user_id,$current_agent,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function select_agent_id($current_agent,$staff_user_id)
	{
		if($stmt = $this->con->prepare("SELECT `agent_name` FROM `staff_added_agent` WHERE `staff_id`=? AND `agent_name`=?"))
		{
			$stmt->bind_param("ss",$staff_user_id,$current_agent);
			
			$stmt->bind_result($res_agent_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_agent_id;
				}
				return False;
			}
		}
	}
	function get_agents_data_with_staff_id($staff_user_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent_name` FROM `staff_added_agent` WHERE `staff_id`=?"))
		{
			$stmt->bind_param("s",$staff_user_id);
			$stmt->bind_result($res_id,$agent_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function delete_staff_added_agent($delet_id)
	{
		if($stmt = $this->con->prepare("DELETE FROM `staff_added_agent` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$delet_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_agent_id_vasuli()
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `agent`"))
		{
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function update_market_setting($main_title,$sub_title)
	{
		if($stmt = $this->con->prepare("UPDATE `market_setting` SET `main_business_title`=?,`sub_title`=?"))
		{
			$stmt->bind_param("ss",$main_title,$sub_title);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_market_setting_details()
	{
		if($stmt = $this->con->prepare("SELECT `main_business_title`, `sub_title` FROM `market_setting`"))
		{
			$stmt->bind_result($main_business_title,$sub_title);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$main_business_title;
					$data[$cntr][1]	=	$sub_title;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_market_setting_details_multi()
	{
		if($stmt = $this->con->prepare("SELECT `main_business_title`, `sub_title` FROM `market_setting`"))
		{
			$stmt->bind_result($main_business_title,$sub_title);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$main_business_title;
					$data[$cntr][1]	=	$sub_title;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_submarket_status()
	{
		if($stmt = $this->con->prepare("SELECT DISTINCT(`sub_title`) FROM `market_setting`"))
		{
			$stmt->bind_result($sub_title);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr]	=	$sub_title;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
    function get_todays_aakde_data_by_select_title($buisness_main_title,$buisness_sub_title,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$query_stmt	=	"";
		if($buisness_sub_title=="ALL")
		{
			$query_stmt="";
		}
		else 
		{
			
			$query_stmt="AND `buisness_sub_title` = '".$buisness_sub_title."'";
		}
		
		
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND  `date`=? ".$query_stmt." ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("s",$search_date);

			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function get_agents_data_by_agent_id($agent_res_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `oc_rate_chillar`, `oc_rate_thok`, `b_rate_chillar`, `b_rate_thok`, `p_rate_chillar`, `p_rate_thok`, `metro_rate_chillar`, `metro_rate_thok`, `parel_rate_chillar`, `parel_rate_thok`, `user_id`, `password`, `date`, `time`,`type`,`thok_rakkam` FROM `agent` Where `id`=?"))
		{
			
			$stmt->bind_param("i",$agent_res_id);
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$date,$time,$type,$thok_rakkam);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[4]	=	$commission;
					$data[5]	=	$oc_rate_chillar;
					$data[6]	=	$oc_rate_thok;
					$data[7]	=	$b_rate_chillar;
					$data[8]	=	$b_rate_thok;
					$data[9]	=	$p_rate_chillar;
					$data[10]	=	$p_rate_thok;
					$data[11]	=	$metro_rate_chillar;
					$data[12]	=	$metro_rate_thok;
					$data[13]	=	$parel_rate_chillar;
					$data[14]	=	$parel_rate_thok;
					$data[15]	=	$user_id;
					$data[16]	=	$password;
					$data[17]	=	$date;
					$data[18]	=	$time;
					$data[19]	=	$type;
					$data[20]	=	$thok_rakkam;
					
					return $data;
				}
				
				
			}
			return false;
		}
	}
	
	function truncate_agent_data($from_date,$to_date)
	{
		
		if($stmt = $this->con->prepare("DELETE FROM `agent`  WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date,$to_date);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_agent_aakade($from_date,$to_date)
	{
		if($stmt = $this->con->prepare("DELETE FROM `agent_aakde` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date,$to_date);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_agent_roznama_data($from_date,$to_date)
	{
		if($stmt = $this->con->prepare("DELETE FROM `agent_rojnama_data`   WHERE `date` BETWEEN ? AND ?  "))
		{
			$stmt->bind_param("ss",$from_date,$to_date);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_cutted_numbers_data()
	{
		if($stmt = $this->con->prepare("DELETE FROM `cutted_numbers_data` "))
		{
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_cutting_aakade_data($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `cutting_aakde` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_cutting_save_data($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `cutting_saved_data` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_cutting_setting($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `cutting_setting` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_finance_manger($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `finance_manager` WHERE `saved_date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_market_setting($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `market_setting` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_offline_staff($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `offline-staff` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_roznama_b_mgmt($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `rojnama_buisness_mgmt` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_saved_commission($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `saved_commission` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_sent_id($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `sent_id` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_shillak_rakkam($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `shillak_rakkam` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_staff_added_agent($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `staff_added_agent` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_winner_akkade($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `winner_aakda` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function insert_color_code($main_category,$sub_category,$color_code)
	{	
		$date= date("y-m-d");
		$time=date("h:i:s");
			
		if($stmt= $this->con->prepare("INSERT INTO `color_setting`(`main_category`, `sub_category`, `color_code`, `date`, `time`) VALUES (?,?,?,?,?)"))
		{
			
			$stmt->bind_param("sssss",$main_category,$sub_category,$color_code,$date,$time);
			
			if($stmt->execute())
			{	
				return true;
			}
			else
			{
				return false;
			}
		}
	}
	
		function get_id($main_category,$sub_category)
		{
			if($stmt = $this->con->prepare("SELECT `id` FROM `color_setting` WHERE `main_category` = ? AND `sub_category` = ? "))
			{
				$stmt->bind_param("ss",$main_category,$sub_category);
				
				$stmt->bind_result($res_id);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_id;
					}
					return False;
				}
			}
		}
		
	function update_color_code($color_code,$db_id)
	{
		
		if($stmt = $this->con->prepare("UPDATE `color_setting` SET `color_code`=? WHERE `id`=?"))
		{
			$stmt->bind_param("ss",$color_code,$db_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_color_of_component($main_cat_id,$sub_cat_id)
		{
			if($stmt = $this->con->prepare("SELECT `color_code` FROM `color_setting` WHERE `main_category` = ? AND `sub_category` = ? "))
			{
				$stmt->bind_param("ss",$main_cat_id,$sub_cat_id);
				
				$stmt->bind_result($res_id);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_id;
					}
					return False;
				}
			}
		}
		function get_agentche_aakade_single_aakade($agent_id,$taarikh,$single_aakda,$buisness_main_title,$buisness_sub_title)
	{
		
		
		$stmt = "";
		if($agent_id=="सर्व दाखवा")
		{
			$agent_id	=	"";
			$stmt = " AND `agent` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent`='".$agent_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
		
		if($single_aakda!="")
		{
			$stmt = $stmt." AND `aakda` = '".$single_aakda."' ";
		}
	
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt." ORDER BY `id` ASC "))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function get_agentche_aakade_double_aakade($agent_id,$taarikh,$double_aakda,$buisness_main_title,$buisness_sub_title)
	{
		$stmt = "";
		if($agent_id=="सर्व दाखवा")
		{
			$agent_id	=	"";
			$stmt = " AND `agent` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent`='".$agent_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
		if($double_aakda!="")
		{
			$stmt = $stmt." AND `aakda` = '".$double_aakda."' ";
		}
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt." ORDER BY `id` ASC "))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function get_agentche_aakade_patta($agent_id,$taarikh,$aakda,$buisness_main_title,$buisness_sub_title)
	{
		$stmt = "";
		if($agent_id=="सर्व दाखवा")
		{
			$agent_id	=	"";
			$stmt = " AND `agent` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent`='".$agent_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
		if($aakda!="")
		{
			$stmt = $stmt." AND `aakda` = '".$aakda."' ";
		}
		
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt." ORDER BY `id` ASC "))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function get_agentche_aakade_type($agent_id,$taarikh,$buisness_main_title,$buisness_sub_title)
	{
		$stmt = "";
		if($agent_id=="सर्व दाखवा")
		{
			$agent_id	=	"";
			$stmt = " AND `agent` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent`='".$agent_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
	
		
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt." ORDER BY `id` ASC "))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
		
	}
	function update_agent_aakade_transfer($count,$to_agent_id)
	{
		
		if($stmt = $this->con->prepare("UPDATE `agent_aakde` SET  `agent`=?  WHERE `id`=?"))
		{
			$stmt->bind_param("ss",$to_agent_id,$count);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	
	/*************************************************New Function***************************/
	function get_all_o_thok_data_for_kalyan_mumbai_load($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{	
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_o_chillar_data_kalyan_mumbai_load($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
		function get_plus_minus_data_from_vasuli_kagad1($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `farak_dhanda`, `farak_jama` FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=? AND (`farak_dhanda`!='' OR `farak_jama`!='')"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_farak_dhanda,$res_farak_jama);
			
			if($stmt->execute())
			{
				$data = array();
				$cntr = 0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_farak_dhanda;
					$data[$cntr][1]	=	$res_farak_jama;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	function get_vasuli_vatap_data_for_vasuli_kagad1($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `vasuli`, `vatap` FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=? AND (`vasuli`!='' OR `vatap`!='')"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_vasuli,$res_vatap);
			
			if($stmt->execute())
			{
				$data = array();
				$cntr = 0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_vasuli;
					$data[$cntr][1]	=	$res_vatap;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	 function get_agent_password($user_id)
		{
			if($stmt = $this->con->prepare("SELECT `password` FROM `agent` WHERE `user_id`=?"))
			{
				$stmt->bind_param("s",$user_id);
				
				$stmt->bind_result($res_password);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_password;
					}
					return False;
				}
			}
		}
	function get_agent_id_from_user_id($userid)
	{

		if($stmt = $this->con->prepare("SELECT `id`, `name`  FROM `agent` WHERE `user_id`=?"))
		{
			$stmt->bind_param("s",$userid);
			
			$stmt->bind_result($res_id,$agent_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				$counter = 0;
				if($stmt->fetch())
				{
					$data[$counter][0]	=	$res_id;
					$data[$counter][1]	=	$agent_name;
				}
				if(!empty($data))
				{
					return $data;
				}
				
			}
			return false;
		}
	}
	function get_agents_data_by_name($searched_agent_name)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `user_id`, `password`, `date`, `time`,`jodi_commission`, `single_pana_commission`, `double_pana_commission`, `triple_pana_commissions`,`police_station`,`agent_commission`,`sangam_rate`,`chitthiwala` FROM `agent` WHERE `name` LIKE '%".$searched_agent_name."%'"))
		{
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time,$jodi_commission,$single_pana_commission,$double_pana_commission,$triple_pana_commission,$police_station,$agent_commission,$sangam_rate,$chitthiwala);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$user_id;
					$data[$cntr][6]	=	$password;
					$data[$cntr][7]	=	$date;
					$data[$cntr][8]	=	$time;
					$data[$cntr][9]	=	$jodi_commission;
					$data[$cntr][10]	=	$single_pana_commission;
					$data[$cntr][11]	=	$double_pana_commission;
					$data[$cntr][12]	=	$triple_pana_commission;
					$data[$cntr][13]	=	$police_station;
					$data[$cntr][14]	=	$agent_commission;
					$data[$cntr][15]	=	$sangam_rate;
					$data[$cntr][16]	=	$chitthiwala;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_upload_number($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `id` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $id;
				}
				return False;
			}
		}
	}
		
	function insert_upload_number($number,$amount)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `amount_table`(`number`, `amount`, `date`, `time`) VALUES(?,?,?,?)"))
		{
			$stmt->bind_param("ssss",$number,$amount,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function update_upload_number($number,$amount,$db_id)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");

		if($stmt = $this->con->prepare("UPDATE `amount_table` SET `number`=?,`amount`=? ,`date`=?,`time`=? WHERE `id`=?"))
		{
				
			$stmt->bind_param("sssss",$number,$amount,$date,$time,$db_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_uploaded_amont($number)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `amount` FROM `amount_table` WHERE `number`=?"))
		{
			$stmt->bind_param("s",$number);

			$stmt->bind_result($res_id,$amount);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$amount;
					
					return $data;
				}
			}
			return false;
		}
	}
	function get_amount_of_first_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_second_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_third_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_fourth_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_fifth_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_sixth_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_seventh_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_eight_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_nineth_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_amount_of_zero_array($number)
	{
		
		if($stmt = $this->con->prepare("SELECT `amount` FROM `amount_table` WHERE `number`=?"))
		{
			
			$stmt->bind_param("s",$number);
			
			$stmt->bind_result($amount);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $amount;
				}
				return False;
			}
		}
	}
	function get_open_load_sheet_double_number($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` LIKE '".$passed_val."%' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
function get_total_amount_of_jodi_for_running($buisness_main_title,$search_date,$crt_numb,$buisness_sub_title)
	{
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `date`='".$search_date."' AND `aakda` =? AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_one($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3 AND `type`='none'"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_two($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_three($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_four($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_five($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_six($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_seven($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_eight($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_nine($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_total_amount_of_tripple_for_running_zero($buisness_main_title,$buisness_sub_title,$search_date,$crt_numb)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$search_date."' AND `aakda` =? AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_param("s",$crt_numb);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_agent_total_amount($sub_title,$today_date,$agent_id)
	{
		
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_sub_title` LIKE '%".$sub_title."%' AND `date`='".$today_date."' AND `agent` =?"))
		{
			
			$stmt->bind_param("s",$agent_id);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_open_load_sheet_data_agent($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_id)
	{
		
		$date_data	=	explode("-",$searched_date);
		
		$searched_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda`=? AND `agent`=?  AND CHAR_LENGTH(`aakda`)=1 AND `type`='none' "))
		{
			
			$stmt->bind_param("ss",$passed_val,$agent_id);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_open_load_sheet_data_jodi_agent($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_id)
	{
		
		$date_data	=	explode("-",$searched_date);
		
		$searched_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda`=? AND `agent`=?  AND CHAR_LENGTH(`aakda`)=2 AND `type`='none' "))
		{
			
			$stmt->bind_param("ss",$passed_val,$agent_id);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_open_load_sheet_data_pana_agent($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_id)
	{
		
		$date_data	=	explode("-",$searched_date);
		
		$searched_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
	
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`=?  AND `aakda`=? AND `agent`=?  AND CHAR_LENGTH(`aakda`)=3 AND `type`='none' "))
		{
			
			$stmt->bind_param("sss",$searched_date,$passed_val,$agent_id);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_agent_commsion($agent_id)
	{
		
		if($stmt = $this->con->prepare("SELECT `agent_commission` FROM `agent` WHERE `id`=?"))
		{
			$stmt->bind_param("s",$agent_id);
			
			$stmt->bind_result($commsion);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					
					return $commsion;
				}
			}
			return false;
		}
	}
	function get_rokadi_amount($agent_id,$today_date)
	{
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `transaction_type`, `amount`, `current_nave_jama`, `current_remain_amount`, `date`, `time`,`added_by` FROM `vasuli_vatap` WHERE `agent_id`=? AND `date`=?"))
		{
			$stmt->bind_param("ss",$agent_id,$today_date);
			
			$stmt->bind_result($res_id,$agent_id,$transaction_type,$amount,$current_nave_jama,$current_remain_amount,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_id;
					$data[$cntr][2]	=	$transaction_type;
					$data[$cntr][3]	=	$amount;
					$data[$cntr][4]	=	$current_nave_jama;
					$data[$cntr][5]	=	$current_remain_amount;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_vasuli_user_password($user_id)
	{
			if($stmt = $this->con->prepare("SELECT `password` FROM `vasuli_user` WHERE `user_id`=?"))
			{
				$stmt->bind_param("s",$user_id);
				
				$stmt->bind_result($res_password);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_password;
					}
					return False;
				}
			}
	}
	function register_new_vasuli_user($user_name,$address,$mobile_no,$vasuli_user_id,$password,$police_station)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `vasuli_user`(`vasuli_user_name`, `address`, `mobile_no`, `user_id`, `password`,`date`,`time`,`police_station`) VALUES(?,?,?,?,?,?,?,?)"))
		{
			
			$stmt->bind_param("ssssssss",$user_name,$address,$mobile_no,$vasuli_user_id,$password,$date,$time,$police_station);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function delete_vasuli_user($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `vasuli_user` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_vasuli_data_by_name($searched_agent_name)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `vasuli_user_name`, `address`, `mobile_no`, `user_id`, `password`, `date`, `time`,`police_station` FROM `vasuli_user` WHERE  `vasuli_user_name` LIKE '%".$searched_agent_name."%'"))
		{
			
			
			$stmt->bind_result($res_id,$vasuli_user_name,$address,$mobile_no,$user_id,$password,$date,$time,$police_station);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$vasuli_user_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$user_id;
					$data[$cntr][5]	=	$password;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$police_station;
					
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function update_new_vasuli_user($agent_name,$address,$mobile_no,$agent_user_id,$password,$agent_id,$police_station)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `vasuli_user` SET `vasuli_user_name`=?,`address`=?,`mobile_no`=?,`user_id`=?,`password`=?,`date`=?,`time`=?,`police_station`=? WHERE `id`=?"))
		{
			$stmt->bind_param("ssssssssi",$agent_name,$address,$mobile_no,$agent_user_id,$password,$date,$time,$police_station,$agent_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_vasuli_user_data_from_id($agent_id)
	{
		
		
		if($stmt = $this->con->prepare("SELECT `id`, `vasuli_user_name`, `address`, `mobile_no`, `user_id`, `password`, `date`, `time`,`police_station` FROM `vasuli_user` WHERE `id`=?"))
		{
			
			$stmt->bind_param("i",$agent_id);
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$user_id,$password,$date,$time,$police_station);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[5]	=	$user_id;
					$data[6]	=	$password;
					$data[7]	=	$date;
					$data[8]	=	$time;
					$data[9]	=	$police_station;
					
					return $data;
				}
			}
			return false;
		}
	}
	function get_jama_nave_amount($search_agent_name)
	{
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `transaction_type`, `amount`, `current_nave_jama`, `current_remain_amount`, `date`, `time` FROM `vasuli_vatap` WHERE `agent_id`=? ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("s",$search_agent_name);
			
			$stmt->bind_result($res_id,$agent_id,$transaction_type,$amount,$current_nave_jama,$current_remain_amount,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					
					$data[0]	=	$res_id;
					$data[1]	=	$agent_id;
					$data[2]	=	$transaction_type;
					$data[3]	=	$amount;
					$data[4]	=	$current_nave_jama;
					$data[5]	=	$current_remain_amount;
					$data[6]	=	$date;
					$data[7]	=	$time;
					
					
					return $data;
				}
				
				
			}
			return false;
		}
	}
	function insert_vasuli_kagad_of_agent_by_vasuli_user($search_agent_name,$transaction_type,$paise,$email,$type)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		$status='pending';
		if($stmt = $this->con->prepare("INSERT INTO `agent_rokadi`(`agent_id`, `rokadi`, `transaction_type`, `added_by`, `status`, `date`, `time`,`type`) VALUES(?,?,?,?,?,?,?,?)"))
		{
			
			$stmt->bind_param("ssssssss",$search_agent_name,$paise,$transaction_type,$email,$status,$date,$time,$type);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_vasuli_vatap_data_vasuli_user($agent_id,$today_date,$transaction_type,$email)
	{
		
		$stmt = "";
		if($agent_id=="all")
		{
			$agent_id	=	"";
			$stmt = " AND `agent_id` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent_id`='".$agent_id."'";
		}
		$tran_stmt="";
		if($transaction_type=="all")
		{
			$transaction_type	=	"";
			$tran_stmt = " AND `transaction_type` LIKE '%%'";
		}
		else if($transaction_type!="")
		{
			$tran_stmt = " AND `transaction_type`='".$transaction_type."'";
		}
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `rokadi`, `transaction_type`, `added_by`, `status`, `date`, `time`,`type` FROM `agent_rokadi` WHERE `date`=? AND `added_by`=?".$stmt.$tran_stmt))
		{
			
			$stmt->bind_param("ss",$today_date,$email);
			
			$stmt->bind_result($res_id,$agent_id,$amount,$transaction_type,$added_by,$status,$date,$time,$type);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_id;
					$data[$cntr][2]	=	$amount;
					$data[$cntr][3]	=	$transaction_type;
					$data[$cntr][4]	=	$added_by;
					$data[$cntr][5]	=	$status;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$type;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_vasuli_vatap_data_admin($agent_id,$today_date,$transaction_type)
	{
		
		$stmt = "";
		if($agent_id=="all")
		{
			$agent_id	=	"";
			$stmt = " AND `agent_id` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent_id`='".$agent_id."'";
		}
		$tran_stmt="";
		if($transaction_type=="all")
		{
			$transaction_type	=	"";
			$tran_stmt = " AND `transaction_type` LIKE '%%'";
		}
		else if($transaction_type!="")
		{
			$tran_stmt = " AND `transaction_type`='".$transaction_type."'";
		}
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `rokadi`, `transaction_type`, `added_by`, `status`, `date`, `time`,`type` FROM `agent_rokadi` WHERE `date`=? ".$stmt.$tran_stmt))
		{
			
			$stmt->bind_param("s",$today_date);
			
			$stmt->bind_result($res_id,$agent_id,$amount,$transaction_type,$added_by,$status,$date,$time,$type);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_id;
					$data[$cntr][2]	=	$amount;
					$data[$cntr][3]	=	$transaction_type;
					$data[$cntr][4]	=	$added_by;
					$data[$cntr][5]	=	$status;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$type;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_rokadi_amount_by_market($agent_id,$today_date)
	{
		
		$market_id="-";
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `transaction_type`, `amount`, `current_nave_jama`, `current_remain_amount`, `date`, `time`,`added_by` FROM `vasuli_vatap` WHERE `agent_id`=? AND `date`=? AND `market_id`='-'"))
		{
			$stmt->bind_param("ss",$agent_id,$today_date);
			
			$stmt->bind_result($res_id,$agent_id,$transaction_type,$amount,$current_nave_jama,$current_remain_amount,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_id;
					$data[$cntr][2]	=	$transaction_type;
					$data[$cntr][3]	=	$amount;
					$data[$cntr][4]	=	$current_nave_jama;
					$data[$cntr][5]	=	$current_remain_amount;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_setting_amount_from_amount_table($passed_val)
	{
		if($stmt = $this->con->prepare("SELECT `amount`FROM `amount_table` WHERE `number`=?"))
			{
				$stmt->bind_param("s",$passed_val);
				
				$stmt->bind_result($res_amount);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_amount;
					}
					return False;
				}
			}
	}
function get_agent_total_amount_table($select_buisness_main_title,$sub_title,$today_date,$agent_id)
	{
		
		$date_data	=	explode("-",$today_date);
		$today_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
	
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$select_buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$sub_title."%' AND `date`='".$today_date."' AND `agent` =? AND `type`='none' "))
		{
			
			$stmt->bind_param("s",$agent_id);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_rokadi_amount_by_market_table($agent_id,$today_date)
	{
		$transaction_type='credit';
		
		$date_data	=	explode("-",$today_date);
		$today_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
	
		if($stmt = $this->con->prepare("SELECT `id`, SUM(`rokadi`)  FROM `agent_rokadi` WHERE `agent_id`=? AND `transaction_type`=? AND `date`=? AND `status`='pending'"))
		{
			
			$stmt->bind_param("sss",$agent_id,$transaction_type,$today_date);
			
			$stmt->bind_result($res_id,$agent_rokadi);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;

				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_rokadi;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_rokadi_amount_by_market_table_new_fun($agent_id,$today_date)
	{
		$transaction_type='credit';
		
		$date_data	=	explode("-",$today_date);
		$today_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
	
		if($stmt = $this->con->prepare("SELECT SUM(`rokadi`)  FROM `agent_rokadi` WHERE `agent_id`=? AND `transaction_type`=? AND `date`=? AND `status`='pending'"))
		{
			
			$stmt->bind_param("sss",$agent_id,$transaction_type,$today_date);
			
			$stmt->bind_result($agent_rokadi);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;

				while($stmt->fetch())
				{
					$data[$cntr]	=	$agent_rokadi;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function add_agent_transaction_details_old($post_search_date,$post_agent_id,$post_business_title,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$transaction_type,$rokadi_status,$post_khadi,$agent_kadi_lavalele,$agent_kharch,$post_final_sp_amount,$post_final_dp_amount,$post_final_tp_amount,$post_final_cp_amount,$post_final_family_amount,$post_total_ring_amount)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		$added_by   =   "";
		if($stmt = $this->con->prepare("INSERT INTO `agents_transaction`(`market_id`, `search_date`, `agent_id`, `sutta_agent_total_amount`, `sutta_agent_commision_rate`, `sutta_agent_win_amount`, `jent_agent_total_amount`, `jent_agent_commision_rate`, `jent_agent_win_amount`, `close_agent_total_amount`, `close_agent_commision_rate`, `close_agent_win_amount`, `open_pana_total_amount`, `open_pana_commsion_rate`, `open_pana_win_amount`, `close_pana_total_amount`, `close_pana_commsion_rate`, `close_pana_win_amount`, `ekun_sutta_jent_close_open_pana`, `agent_commision`, `agent_rokadi`, `total_of_all`, `open`, `close`, `ekun_open_close`, `nava_jama_text`, `nave_jama_amount`, `total`, `final_text`, `final_total`, `date`, `time`,`transaction_type`,`rokadi_status`,`khadi`,`khadi_lavalele`,`agent_kharch`,`added_by`,`sp_amount`, `dp_amount`, `tp_amount`, `cp_amount`, `family_amount`, `ring_amount`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			
			$stmt->bind_param("ssssssssssssssssssssssssssssssssssssssssssss",$post_business_title,$post_search_date,$post_agent_id,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$date,$time,$transaction_type,$rokadi_status,$post_khadi,$agent_kadi_lavalele,$agent_kharch,$added_by,$post_final_sp_amount,$post_final_dp_amount,$post_final_tp_amount,$post_final_cp_amount,$post_final_family_amount,$post_total_ring_amount);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function add_agent_transaction_details($search_date,$agent_id,$select_buisness_main_title,$winner_amount_kalyan,$single_commission ,$kalyan_single_amount,$jodi_amount_kalyan,$jodi_commission,$kalyan_jodi_amount,$winner_amount_kalyan_close,$single_commission_close,$kalyan_close_amount,$pana_amount_kalyan_open,$o_cal_amount,$total_open_pana_amount,$pana_amount_kalyan_close,$cal_amount_close,$total_close_pana_amount,$ekun_amount,$total_commision,$total_rokadi_amount,$total_all,$get_amount_open,$get_amount_close,$total_open_close_amount,$res_current_nave_jama,$res_current_remain_amount,$total,$jama_nave_text,$final_total_jama_nave,$transaction_type,$rokadi_status,$get_khadi_amount,$agent_kadi_lavalele,$agent_kharch_calculation,$final_sp_amount,$final_dp_amount,$final_tp_amount,$final_cp_amount,$final_family_amount,$total_ring_amount,$final_sangam_amount,$total_xx_amount,$sp_description,$dp_description,$tp_description,$cp_description,$family_description,$ring_description,$sangam_description,$xx_description,$chuk_nave_calculation,$chuk_dene_amount,$kharch_description)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		$added_by   =   "";

		if($stmt = $this->con->prepare("INSERT INTO `agents_transaction`(`market_id`, `search_date`, `agent_id`, `sutta_agent_total_amount`, `sutta_agent_commision_rate`, `sutta_agent_win_amount`, `jent_agent_total_amount`, `jent_agent_commision_rate`, `jent_agent_win_amount`, `close_agent_total_amount`, `close_agent_commision_rate`, `close_agent_win_amount`, `open_pana_total_amount`, `open_pana_commsion_rate`, `open_pana_win_amount`, `close_pana_total_amount`, `close_pana_commsion_rate`, `close_pana_win_amount`, `ekun_sutta_jent_close_open_pana`, `agent_commision`, `agent_rokadi`, `total_of_all`, `open`, `close`, `ekun_open_close`, `nava_jama_text`, `nave_jama_amount`, `total`, `final_text`, `final_total`, `date`, `time`,`transaction_type`,`rokadi_status`,`khadi`,`khadi_lavalele`,`agent_kharch`,`added_by`,`sp_amount`, `dp_amount`, `tp_amount`, `cp_amount`, `family_amount`, `ring_amount`,`sangam_amount`,`xx_amount`,`sp_description`,`dp_description`,`tp_description`,`cp_description`,`family_description`,`ring_description`,`sangam_description`,`xx_description`,`chuk_nave`,`chuk_dene`,`kharch_description`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssssssssssssssssssssssssssssssssssssssssssssssssssssss",$select_buisness_main_title,$search_date,$agent_id,$winner_amount_kalyan,$single_commission,$kalyan_single_amount,$jodi_amount_kalyan,$jodi_commission,$kalyan_jodi_amount,$winner_amount_kalyan_close,$single_commission_close,$kalyan_close_amount,$pana_amount_kalyan_open,$o_cal_amount,$total_open_pana_amount,$pana_amount_kalyan_close,$cal_amount_close,$total_close_pana_amount,$ekun_amount,$total_commision,$total_rokadi_amount,$total_all,$get_amount_open,$get_amount_close,$total_open_close_amount,$res_current_nave_jama,$res_current_remain_amount,$total,$jama_nave_text,$final_total_jama_nave,$date,$time,$transaction_type,$rokadi_status,$get_khadi_amount,$agent_kadi_lavalele,$agent_kharch_calculation,$added_by,$final_sp_amount,$final_dp_amount,$final_tp_amount,$final_cp_amount,$final_family_amount,$total_ring_amount,$final_sangam_amount,$total_xx_amount,$sp_description,$dp_description,$tp_description,$cp_description,$family_description,$ring_description,$sangam_description,$xx_description,$chuk_nave_calculation,$chuk_dene_amount,$kharch_description);
			
			if($stmt->execute())
			{
				return true;
			}
			else
			{
				 echo $stmt->error;
			}
			return false;
		}
	}
	function nave_amount_from_agent_rokadi($search_agent_name)
	{
		
		if($stmt = $this->con->prepare("SELECT SUM(`rokadi`) FROM `agent_rokadi` WHERE `agent_id`=? AND `status`='pending' AND `type`='नावे' AND `transaction_type`='debit'"))
		{
			
			$stmt->bind_param("s",$search_agent_name);
			
			$stmt->bind_result($agent_rokadi);
			
			if($stmt->execute())
			{
			
				
				if($stmt->fetch())
				{
					
					return $agent_rokadi;
				}
				
				
			}
			return false;
		}
	}
	function get_jama_nave_amount_agent_transaction($search_agent_name)
	{
		
		if($stmt = $this->con->prepare("SELECT `id`,`final_text`,`final_total` FROM `agents_transaction` WHERE `final_text`='नावे' AND `agent_id`=?   ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("s",$search_agent_name);
			
			$stmt->bind_result($res_id,$current_nave_jama,$current_remain_amount);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					
					$data[0]	=	$res_id;
					$data[1]	=	$current_nave_jama;
					$data[2]	=	$current_remain_amount;
					
					return $data;
				}
				
				
			}
			return false;
		}
	}
	function get_nave_amount_agent_transaction($search_agent_name)
	{
		
		if($stmt = $this->con->prepare("SELECT `id`,`final_text`,`final_total` FROM `agents_transaction` WHERE `final_text`='जमा' AND `agent_id`=?   ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("s",$search_agent_name);
			
			$stmt->bind_result($res_id,$current_nave_jama,$current_remain_amount);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					
					$data[0]	=	$res_id;
					$data[1]	=	$current_nave_jama;
					$data[2]	=	$current_remain_amount;
					
					return $data;
				}
				
				
			}
			return false;
		}
	}
	function get_jama_nave_amount_agent_transaction_vauli_user($search_agent_name)
	{
		
		if($stmt = $this->con->prepare("SELECT `id`, `nava_jama_text`,`nave_jama_amount` FROM `agents_transaction` WHERE `agent_id`=?   ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("s",$search_agent_name);
			
			$stmt->bind_result($res_id,$current_nave_jama,$current_remain_amount);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					
					$data[0]	=	$res_id;
					$data[1]	=	$current_nave_jama;
					$data[2]	=	$current_remain_amount;
					
					return $data;
				}
				
				
			}
			return false;
		}
	}
	function get_db_id_of_agent_from_transcation_table($post_search_date,$post_agent_id,$post_business_title)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `agents_transaction` WHERE `market_id`=? AND `search_date`=? AND `agent_id`=?"))
			{
				$stmt->bind_param("sss",$post_business_title,$post_search_date,$post_agent_id);
				
				$stmt->bind_result($res_id);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_id;
					}
					return False;
				}
			}
	}
	function update_agent_transaction_details($post_search_date,$post_agent_id,$post_business_title,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$current_status,$current_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$transaction_type,$rokadi_status,$db_id,$post_khadi)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `agents_transaction` SET `market_id`=?,`search_date`=?,`agent_id`=?,`sutta_agent_total_amount`=?,
		`sutta_agent_commision_rate`=?,`sutta_agent_win_amount`=?,
		`jent_agent_total_amount`=?,`jent_agent_commision_rate`=?,
		`jent_agent_win_amount`=?,`close_agent_total_amount`=?,
		`close_agent_commision_rate`=?,`close_agent_win_amount`=?,
		`open_pana_total_amount`=?,`open_pana_commsion_rate`=?,`open_pana_win_amount`=?,
		`close_pana_total_amount`=?,`close_pana_commsion_rate`=?,`close_pana_win_amount`=?,`ekun_sutta_jent_close_open_pana`=?,`agent_commision`=?,`agent_rokadi`=?,
		`total_of_all`=?,`open`=?,`close`=?,`ekun_open_close`=?,`nava_jama_text`=?,`nave_jama_amount`=?,`total`=?,`final_text`=?,`final_total`=?,`date`=?,`time`=?,`transaction_type`=?,`rokadi_status`=? ,`khadi`=?  WHERE `id`=?"))
		{
			
			$stmt->bind_param("ssssssssssssssssssssssssssssssssssss",$post_business_title,$post_search_date,$post_agent_id,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$date,$time,$transaction_type,$rokadi_status,$db_id,$post_khadi);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_all_agents_data()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `user_id`, `password`, `date`, `time` FROM `agent`"))
		{
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$user_id;
					$data[$cntr][6]	=	$password;
					$data[$cntr][7]	=	$date;
					$data[$cntr][8]	=	$time;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_agent_transaction_details($buisness_main_title,$today_date,$agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `market_id`, `search_date`, `agent_id`, `sutta_agent_total_amount`, `sutta_agent_commision_rate`, `sutta_agent_win_amount`, `jent_agent_total_amount`, `jent_agent_commision_rate`, `jent_agent_win_amount`, `close_agent_total_amount`, `close_agent_commision_rate`, `close_agent_win_amount`, `open_pana_total_amount`, `open_pana_commsion_rate`, `open_pana_win_amount`, `close_pana_total_amount`, `close_pana_commsion_rate`, `close_pana_win_amount`, `ekun_sutta_jent_close_open_pana`, `agent_commision`, `agent_rokadi`, `total_of_all`, `open`, `close`, `ekun_open_close`, `nava_jama_text`, `nave_jama_amount`, `total`, `final_text`, `final_total`, `date`, `time`, `transaction_type`,`rokadi_status`,`khadi`,`khadi_lavalele`,`agent_kharch`,`sp_amount`, `dp_amount`, `tp_amount`, `cp_amount`, `family_amount`, `ring_amount`,`sangam_amount`, `xx_amount`,`sp_description`,`dp_description`,`tp_description`,`cp_description`,`family_description`,`ring_description`,`sangam_description`,`xx_description`,`chuk_nave`,`chuk_dene`,`kharch_description` FROM `agents_transaction` WHERE `market_id`=? AND `search_date`=? AND `agent_id`=?"))
		{			
			$stmt->bind_param("sss",$buisness_main_title,$today_date,$agent_id);
			
			$stmt->bind_result($res_id,$post_business_title,$post_search_date,$post_agent_id,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$date,$time,$transaction_type,$rokadi_status,$khadi,$khadi_lavalele,$agent_kharch,$post_final_sp_amount,$post_final_dp_amount,$post_final_tp_amount,$post_final_cp_amount,$post_final_family_amount,$post_total_ring_amount,$sangam_amount,$total_xx_amount,$sp_description,$dp_description,$tp_description,$cp_description,$family_description,$ring_description,$sangam_description,$xx_description,$chuk_nave,$chuk_dene,$kharch_description);
		
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					
					$data[0]	=	$res_id;
					$data[1]	=	$post_business_title;
					$data[2]	=	$post_search_date;
					$data[3]	=	$post_agent_id;
					$data[4]	=	$post_sutta_amount;
					$data[5]	=	$post_sutta_rate;
					$data[6]	=	$post_sutta_win_amount;
					$data[7]	=	$post_jent_amount;
					$data[8]	=	$post_jent_rate;
					$data[9]	=	$post_jent_win_amount;
					$data[10]	=	$post_close_amount;
					$data[11]	=	$post_close_rate;
					$data[12]	=	$post_close_win_amount;
					$data[13]	=	$post_pana_open_amount;
					$data[14]	=	$post_pana_open_rate;
					$data[15]	=	$post_pana_open_win_amount;
					$data[16]	=	$post_pana_close_amount;
					$data[17]	=	$post_pana_close_rate;
					$data[18]	=	$post_pana_close_win_amount;
					$data[19]	=	$post_ekum_amount;
					$data[20]	=	$post_total_commision;
					$data[21]	=	$post_total_rokadi_amount;
					$data[22]	=	$post_total;
					$data[23]	=	$post_open;
					$data[24]	=	$post_close;
					$data[25]	=	$post_total_open_close;
					$data[26]	=	$post_current_nave_jama_text;
					$data[27]	=	$post_current_nave_jama_amount;
					$data[28]	=	$post_current_total;
					$data[29]	=	$post_final_jama_nave_text;
					$data[30]	=	$post_final_jama_nave_amount;
					$data[31]	=	$date;
					$data[32]	=	$time;
					$data[33]	=	$transaction_type;
					$data[34]	=	$rokadi_status;
					$data[35]	=	$khadi;
					$data[36]	=	$khadi_lavalele;
					$data[37]	=	$agent_kharch;
					$data[38]	=	$post_final_sp_amount;
					$data[39]	=	$post_final_dp_amount;
					$data[40]	=	$post_final_tp_amount;
					$data[41]	=	$post_final_cp_amount;
					$data[42]	=	$post_final_family_amount;
					$data[43]	=	$post_total_ring_amount;
					$data[44]	=	$sangam_amount;
					$data[45]	=	$total_xx_amount;
					$data[46]	=	$sp_description;
					$data[47]	=	$dp_description;
					$data[48]	=	$tp_description;
					$data[49]	=	$cp_description;
					$data[50]	=	$family_description;
					$data[51]	=	$ring_description;
					$data[52]	=	$sangam_description;
					$data[53]	=	$xx_description;
					$data[54]	=	$chuk_nave;
					$data[55]	=	$chuk_dene;
					$data[56]	=	$kharch_description;
					
					return $data;
				}
				
				
			}
			return false;
		}
	}
	
	function get_transaction_report_admin($agent_id,$tdate,$buisness_main_title,$user_id,$police_station)
	{
		//$date_data	=	explode("-",$tdate);
		//$tdate	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		$stmt = "";
		if($agent_id=="all")
		{
			$agent_id	=	"";
			$stmt = " AND  A.`agent_id` LIKE '%".$agent_id."%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND  A.`agent_id`='".$agent_id."'";
		}
	
		$user_stmt = "";
		if($user_id=="all")
		{
			$user_id	=	"";
			$user_stmt = " AND  A.`added_by` LIKE '%".$user_id."%'";
		}
		else if($user_id!="")
		{
			$user_stmt = " AND  A.`added_by` LIKE '%".$user_id."%'";
		}
		$b_stmt = "";
		if($buisness_main_title=="all")
		{
			$buisness_main_title	=	"";
			$b_stmt = " AND  A.`market_id` LIKE '%".$buisness_main_title."%'";
		}
		else if($buisness_main_title!="")
		{
			$b_stmt = " AND  A.`market_id`='".$buisness_main_title."'";
		}
		$p_stmt = "";
		if($police_station=="all")
		{
			$police_station	=	"";
			$p_stmt = " AND  B.`police_station` LIKE '%".$police_station."%'";
		}
		else if($police_station!="")
		{
			$p_stmt = " AND  B.`police_station`='".$police_station."'";
		}
		
		if($stmt = $this->con->prepare("SELECT A.`id`, A.`market_id`, A.`search_date`, A.`agent_id`, A.`sutta_agent_total_amount`, A.`sutta_agent_commision_rate`, A.`sutta_agent_win_amount`, A.`jent_agent_total_amount`, A.`jent_agent_commision_rate`, A.`jent_agent_win_amount`, A.`close_agent_total_amount`, A.`close_agent_commision_rate`, A.`close_agent_win_amount`, A.`open_pana_total_amount`, A.`open_pana_commsion_rate`, A.`open_pana_win_amount`, A.`close_pana_total_amount`, A.`close_pana_commsion_rate`, A.`close_pana_win_amount`, A.`ekun_sutta_jent_close_open_pana`, A.`agent_commision`, A.`agent_rokadi`, A.`total_of_all`, A.`open`, A.`close`, A.`ekun_open_close`, A.`nava_jama_text`, A.`nave_jama_amount`, A.`total`, A.`final_text`, A.`final_total`, A.`date`, A.`time`, A.`transaction_type`, A.`rokadi_status`, A.`added_by`, A.`khadi`, A.`khadi_lavalele`, A.`agent_kharch` ,  A.`sp_amount`, A.`dp_amount`, A.`tp_amount`, A.`cp_amount`, A.`family_amount`, A.`ring_amount`, A.`sangam_amount`, A.`xx_amount`,A.`chuk_nave`,A.`chuk_dene` FROM `agents_transaction` AS A INNER JOIN `agent` AS B ON A.`agent_id`=B.`id` WHERE  A.`search_date`=?".$stmt.$b_stmt.$user_stmt.$p_stmt))
		{
			$stmt->bind_param("s",$tdate);
			
			$stmt->bind_result($res_id,$post_business_title,$post_search_date,$post_agent_id,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$date,$time,$transaction_type,$rokadi_status,$added_by,$khadi,$khadi_lavalele,$agent_kharch,$post_final_sp_amount,$post_final_dp_amount,$post_final_tp_amount,$post_final_cp_amount,$post_final_family_amount,$post_total_ring_amount,$sangam_amount,$xx_amount,$chuk_nave,$chuk_dene);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$counter][0]	=	$res_id;
					$data[$counter][1]	=	$post_business_title;
					$data[$counter][2]	=	$post_search_date;
					$data[$counter][3]	=	$post_agent_id;
					$data[$counter][4]	=	$post_sutta_amount;
					$data[$counter][5]	=	$post_sutta_rate;
					$data[$counter][6]	=	$post_sutta_win_amount;
					$data[$counter][7]	=	$post_jent_amount;
					$data[$counter][8]	=	$post_jent_rate;
					$data[$counter][9]	=	$post_jent_win_amount;
					$data[$counter][10]	=	$post_close_amount;
					$data[$counter][11]	=	$post_close_rate;
					$data[$counter][12]	=	$post_close_win_amount;
					$data[$counter][13]	=	$post_pana_open_amount;
					$data[$counter][14]	=	$post_pana_open_rate;
					$data[$counter][15]	=	$post_pana_open_win_amount;
					$data[$counter][16]	=	$post_pana_close_amount;
					$data[$counter][17]	=	$post_pana_close_rate;
					$data[$counter][18]	=	$post_pana_close_win_amount;
					$data[$counter][19]	=	$post_ekum_amount;
					$data[$counter][20]	=	$post_total_commision;
					$data[$counter][21]	=	$post_total_rokadi_amount;
					$data[$counter][22]	=	$post_total;
					$data[$counter][23]	=	$post_open;
					$data[$counter][24]	=	$post_close;
					$data[$counter][25]	=	$post_total_open_close;
					$data[$counter][26]	=	$post_current_nave_jama_text;
					$data[$counter][27]	=	$post_current_nave_jama_amount;
					$data[$counter][28]	=	$post_current_total;
					$data[$counter][29]	=	$post_final_jama_nave_text;
					$data[$counter][30]	=	$post_final_jama_nave_amount;
					$data[$counter][31]	=	$date;
					$data[$counter][32]	=	$time;
					$data[$counter][33]	=	$transaction_type;
					$data[$counter][34]	=	$rokadi_status;
					$data[$counter][35]	=	$added_by;
					$data[$counter][36]	=	$khadi;
					$data[$counter][37]	=	$khadi_lavalele;
					$data[$counter][38]	=	$agent_kharch;
					$data[$counter][39]	=	$post_final_sp_amount;
					$data[$counter][40]	=	$post_final_dp_amount;
					$data[$counter][41]	=	$post_final_tp_amount;
					$data[$counter][42]	=	$post_final_cp_amount;
					$data[$counter][43]	=	$post_final_family_amount;
					$data[$counter][44]	=	$post_total_ring_amount;
					$data[$counter][45]	=	$sangam_amount;
					$data[$counter][46]	=	$xx_amount;
					$data[$counter][47]	=	$chuk_nave;
					$data[$counter][48]	=	$chuk_dene;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_open_load_sheet_data_jodi_open_and_close($buisness_main_title,$search_date,$passed_val)
	{
		
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `date`='".$search_date."' AND `aakda`=?  AND CHAR_LENGTH(`aakda`)=2"))
		{
			
			$stmt->bind_param("s",$passed_val);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function save_new_khadi($agent_id,$amount,$transaction_type,$date)
	{
		
		$time = date("h:i:s A");
		$status="pending";
		if($stmt = $this->con->prepare("INSERT INTO `khadi`(`agent_id`, `amount`, `date`, `time`,`transaction_type`,`status`) VALUES(?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssss",$agent_id,$amount,$date,$time,$transaction_type,$status);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_khadi_data($search_new_agent_name,$search_transaction_type,$from_date_data,$to_date_data)
	{
	    $agent_name_stmt    =   "";
	    if($search_new_agent_name=="all")
	    {
	        $agent_name_stmt    =   " AND `agent_id` LIKE '%%'";
	    }
	    else
	    {
	        $agent_name_stmt    =   " AND `agent_id`='".$search_new_agent_name."'";
	    }
	    
	    $search_transaction_stmt    =   "";
	    if($search_transaction_type=="all")
	    {
	        $search_transaction_stmt    =   " AND `transaction_type` LIKE '%%'";
	    }
	    else
	    {
	        $search_transaction_stmt    =   " AND `transaction_type` = '".$search_transaction_type."'";
	    }

		if($stmt_select = $this->con->prepare("SELECT `id`, `agent_id`, `amount`, `date`, `time`,`transaction_type`,`status` FROM `khadi` WHERE (`date` BETWEEN ? AND ?) ".$agent_name_stmt.$search_transaction_stmt))
		{
			$stmt_select->bind_param("ss",$from_date_data,$to_date_data);
			$stmt_select->bind_result($id,$agent_id,$amount,$date,$time,$transaction_type,$status);
				
			if($stmt_select->execute())
			{
					$counter = 0;
					$agent_data	=	array();
					
					while($stmt_select->fetch())
					{
						$agent_data[$counter][0]	=	$id;
						$agent_data[$counter][1]	=	$agent_id;
						$agent_data[$counter][2]	=	$amount;
						$agent_data[$counter][3]	=	$date;
						$agent_data[$counter][4]	=	$time;
						$agent_data[$counter][5]	=	$transaction_type;
						$agent_data[$counter][6]	=	$status;
						$counter++;
					}
					
					if(!empty($agent_data))
					{
						return $agent_data;
					}
					else
					{
						return false;
					}
			}
		}
	}
	function delete_khadi_data($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `khadi` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_khadi_details_for_edit($agent_id)
	{
			
		if($stmt_select = $this->con->prepare("SELECT `id`, `agent_id`, `amount`, `date`, `time`,`transaction_type` FROM `khadi` WHERE `id`=?"))
			{
				$stmt_select->bind_param("i",$agent_id);

				$stmt_select->bind_result($res_id,$res_agent_id,$res_amount,$date,$time,$transaction_type);
				
				if($stmt_select->execute())
				{
					
					$agent_details	=	array();
					
					if($stmt_select->fetch())
					{
						
						$agent_details[0]	=	$res_id;
						$agent_details[1]	=	$res_agent_id;
						$agent_details[2]	=	$res_amount;
						$agent_details[3]	=	$date;
						$agent_details[4]	=	$time;
						$agent_details[5]	=	$transaction_type;
						
						return $agent_details;
					}
					else
					{
						return false;
					}
				}
			}
	}

	function update_new_khadi($agent_name,$amount,$agent_id,$transaction_type)
	{ 
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `khadi` SET `agent_id`=?,`amount`=?,`date`=?,`time`=?,`transaction_type`=? WHERE `id`=?"))
		{ 
			$stmt->bind_param("sssssi",$agent_name,$amount,$date,$time,$transaction_type,$agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	function get_agent_name_from_table($agent_id)
	{
			if($stmt_select = $this->con->prepare("SELECT `name` FROM `agent` WHERE `id`=?"))
			{
				$stmt_select->bind_param("s",$agent_id);
				
				$stmt_select->bind_result($name);
				
				if($stmt_select->execute())
				{
					if($stmt_select->fetch())
					{
						return $name;
					}
					return false;
				}
			}
	}
	//12-10
	function get_agent_khadi_amount($agent_id,$transaction_type)
	{
		$status='pending';
		if($stmt_select = $this->con->prepare("SELECT SUM(`amount`) FROM `khadi` WHERE `agent_id`=? AND `transaction_type`=? AND `status`=?"))
		{
			$stmt_select->bind_param("sss",$agent_id,$transaction_type,$status);
			
			$stmt_select->bind_result($name);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $name;
				}
				return false;
			}
		}
	}
	function update_khadi_status($post_agent_id)
	{
		if($stmt = $this->con->prepare("UPDATE `khadi` SET `status`='yes' WHERE `agent_id`=?"))
		{ 
			$stmt->bind_param("s",$post_agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	function delete_agent_rokadi_data($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `agent_rokadi` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function update_rokadi_status($post_agent_id)
	{
		if($stmt = $this->con->prepare("UPDATE `agent_rokadi` SET `status`='yes' WHERE `agent_id`=?"))
		{ 
			$stmt->bind_param("s",$post_agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	function get_jama_nave_amount_agent_transaction_vauli_user1($search_agent_name)
	{
		
		if($stmt = $this->con->prepare("SELECT `id`,`final_text`,`final_total` FROM `agents_transaction` WHERE `agent_id`=?   ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("s",$search_agent_name);
			
			$stmt->bind_result($res_id,$current_nave_jama,$current_remain_amount);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					
					$data[0]	=	$res_id;
					$data[1]	=	$current_nave_jama;
					$data[2]	=	$current_remain_amount;
					
					return $data;
				}
				
				
			}
			return false;
		}
	}
	function save_new_kharch($agent_id,$amount,$date,$description)
	{
		
		$time = date("h:i:s A");
		$status="pending";
		if($stmt = $this->con->prepare("INSERT INTO `kharch`(`agent_id`, `amount`, `date`, `time`,`status`,`description`) VALUES(?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssss",$agent_id,$amount,$date,$time,$status,$description);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function save_new_chuk_rakkam($agent_id,$amount,$date)
	{
		
		$time = date("h:i:s A");
		$status="pending";
		if($stmt = $this->con->prepare("INSERT INTO `chuk_rakkam`(`agent_id`, `amount`, `date`, `time`,`status`) VALUES(?,?,?,?,?)"))
		{
			$stmt->bind_param("sssss",$agent_id,$amount,$date,$time,$status);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function save_new_chuk_rakkam_agentla_dene($agent_id,$amount,$date)
	{
		
		$time = date("h:i:s A");
		$status="pending";
		if($stmt = $this->con->prepare("INSERT INTO `chuk_rakkam_dene_agentla`(`agent_id`, `amount`, `date`, `time`,`status`) VALUES(?,?,?,?,?)"))
		{
			$stmt->bind_param("sssss",$agent_id,$amount,$date,$time,$status);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	
	function get_kharch_data($search_new_agent_name,$from_date_data,$to_date_data)
	{
		$agent_name_stmt    =   "";
	    if($search_new_agent_name=="all")
	    {
	        $agent_name_stmt    =   " AND `agent_id` LIKE '%%'";
	    }
	    else
	    {
	        $agent_name_stmt    =   " AND `agent_id`='".$search_new_agent_name."'";
	    }
	    
		if($stmt_select = $this->con->prepare("SELECT `id`, `agent_id`, `amount`, `date`, `time`,`status`,`description` FROM `kharch` where `date` BETWEEN ? AND ?".$agent_name_stmt))
		{
			$stmt_select->bind_param("ss",$from_date_data,$to_date_data);
			$stmt_select->bind_result($id,$agent_id,$amount,$date,$time,$status,$description);
				
			if($stmt_select->execute())
			{
					$counter = 0;
					$agent_data	=	array();
					
					while($stmt_select->fetch())
					{
						$agent_data[$counter][0]	=	$id;
						$agent_data[$counter][1]	=	$agent_id;
						$agent_data[$counter][2]	=	$amount;
						$agent_data[$counter][3]	=	$date;
						$agent_data[$counter][4]	=	$time;
						$agent_data[$counter][6]	=	$status;
						$agent_data[$counter][7]	=	$description;
						
						$counter++;
					}
					
					if(!empty($agent_data))
					{
						return $agent_data;
					}
					else
					{
						return false;
					}
			}
		}
	}
	
	function get_chuk_rakkam_data($search_new_agent_name,$from_date_data,$to_date_data)
	{
	    $agent_name_stmt    =   "";
	    if($search_new_agent_name=="all")
	    {
	        $agent_name_stmt    =   " AND `agent_id` LIKE '%%'";
	    }
	    else
	    {
	        $agent_name_stmt    =   " AND `agent_id`='".$search_new_agent_name."'";
	    }
	    
		if($stmt_select = $this->con->prepare("SELECT `id`, `agent_id`, `amount`, `date`, `time`,`status` FROM `chuk_rakkam`WHERE `date` BETWEEN ? AND ? ".$agent_name_stmt))
		{
			$stmt_select->bind_param("ss",$from_date_data,$to_date_data);
			$stmt_select->bind_result($id,$agent_id,$amount,$date,$time,$status);
				
			if($stmt_select->execute())
			{
					$counter = 0;
					$agent_data	=	array();
					
					while($stmt_select->fetch())
					{
						$agent_data[$counter][0]	=	$id;
						$agent_data[$counter][1]	=	$agent_id;
						$agent_data[$counter][2]	=	$amount;
						$agent_data[$counter][3]	=	$date;
						$agent_data[$counter][4]	=	$time;
						$agent_data[$counter][6]	=	$status;
						$counter++;
					}
					
					if(!empty($agent_data))
					{
						return $agent_data;
					}
					else
					{
						return false;
					}
			}
		}
	}
	
	function get_chuk_rakkam_data_agentla_dilele($search_new_agent_name,$from_date_data,$to_date_data)
	{
	    $agent_name_stmt    =   "";
	    if($search_new_agent_name=="all")
	    {
	        $agent_name_stmt    =   " AND `agent_id` LIKE '%%'";
	    }
	    else
	    {
	        $agent_name_stmt    =   " AND `agent_id`='".$search_new_agent_name."'";
	    }
	    
		if($stmt_select = $this->con->prepare("SELECT `id`, `agent_id`, `amount`, `date`, `time`,`status` FROM `chuk_rakkam_dene_agentla` WHERE `date` BETWEEN ? AND ? ".$agent_name_stmt))
		{
			$stmt_select->bind_param("ss",$from_date_data,$to_date_data);
			$stmt_select->bind_result($id,$agent_id,$amount,$date,$time,$status);
				
			if($stmt_select->execute())
			{
					$counter = 0;
					$agent_data	=	array();
					
					while($stmt_select->fetch())
					{
						$agent_data[$counter][0]	=	$id;
						$agent_data[$counter][1]	=	$agent_id;
						$agent_data[$counter][2]	=	$amount;
						$agent_data[$counter][3]	=	$date;
						$agent_data[$counter][4]	=	$time;
						$agent_data[$counter][6]	=	$status;
						$counter++;
					}
					
					if(!empty($agent_data))
					{
						return $agent_data;
					}
					else
					{
						return false;
					}
			}
		}
	}
	
	function delete_kharch_data($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `kharch` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_chuk_rakkam_data($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `chuk_rakkam` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_chuk_rakkam_data_from_dilele_chuk($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `chuk_rakkam_dene_agentla` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_kharch_details_for_edit($agent_id)
	{
			
		if($stmt_select = $this->con->prepare("SELECT `id`, `agent_id`, `amount`, `date`, `time` FROM `kharch` WHERE `id`=?"))
			{
				$stmt_select->bind_param("i",$agent_id);

				$stmt_select->bind_result($res_id,$res_agent_id,$res_amount,$date,$time);
				
				if($stmt_select->execute())
				{
					
					$agent_details	=	array();
					
					if($stmt_select->fetch())
					{
						
						$agent_details[0]	=	$res_id;
						$agent_details[1]	=	$res_agent_id;
						$agent_details[2]	=	$res_amount;
						$agent_details[3]	=	$date;
						$agent_details[4]	=	$time;
						
						
						return $agent_details;
					}
					else
					{
						return false;
					}
				}
			}
	}
	
	function get_chuk_rakkam_details_for_edit($agent_id)
	{
			
		if($stmt_select = $this->con->prepare("SELECT `id`, `agent_id`, `amount`, `date`, `time` FROM `chuk_rakkam` WHERE `id`=?"))
			{
				$stmt_select->bind_param("i",$agent_id);

				$stmt_select->bind_result($res_id,$res_agent_id,$res_amount,$date,$time);
				
				if($stmt_select->execute())
				{
					
					$agent_details	=	array();
					
					if($stmt_select->fetch())
					{
						
						$agent_details[0]	=	$res_id;
						$agent_details[1]	=	$res_agent_id;
						$agent_details[2]	=	$res_amount;
						$agent_details[3]	=	$date;
						$agent_details[4]	=	$time;
						
						
						return $agent_details;
					}
					else
					{
						return false;
					}
				}
			}
	}
	
	function get_chuk_rakkam_details_for_edit_agentla_dilele($agent_id)
	{
			
		if($stmt_select = $this->con->prepare("SELECT `id`, `agent_id`, `amount`, `date`, `time` FROM `chuk_rakkam_dene_agentla` WHERE `id`=?"))
			{
				$stmt_select->bind_param("i",$agent_id);

				$stmt_select->bind_result($res_id,$res_agent_id,$res_amount,$date,$time);
				
				if($stmt_select->execute())
				{
					
					$agent_details	=	array();
					
					if($stmt_select->fetch())
					{
						
						$agent_details[0]	=	$res_id;
						$agent_details[1]	=	$res_agent_id;
						$agent_details[2]	=	$res_amount;
						$agent_details[3]	=	$date;
						$agent_details[4]	=	$time;
						
						
						return $agent_details;
					}
					else
					{
						return false;
					}
				}
			}
	}

	function update_new_kharch($agent_name,$amount,$agent_id)
	{ 
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `khadi` SET `agent_id`=?,`amount`=?,`date`=?,`time`=? WHERE `id`=?"))
		{ 
			$stmt->bind_param("ssssi",$agent_name,$amount,$date,$time,$agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	
	function update_new_chuk_rakkam($agent_name,$amount,$agent_id)
	{ 
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `chuk_rakkam` SET `agent_id`=?,`amount`=?,`date`=?,`time`=? WHERE `id`=?"))
		{ 
			$stmt->bind_param("ssssi",$agent_name,$amount,$date,$time,$agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	
	function update_new_chuk_rakkam_dilele_agentla($agent_name,$amount,$agent_id)
	{ 
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `chuk_rakkam_dene_agentla` SET `agent_id`=?,`amount`=?,`date`=?,`time`=? WHERE `id`=?"))
		{ 
			$stmt->bind_param("ssssi",$agent_name,$amount,$date,$time,$agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	
	function get_agent_khaarch_amount($agent_id)
	{
		$status='pending';
		if($stmt_select = $this->con->prepare("SELECT SUM(`amount`) FROM `kharch` WHERE `agent_id`=?  AND `status`=?"))
		{
			$stmt_select->bind_param("ss",$agent_id,$status);
			
			$stmt_select->bind_result($name);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $name;
				}
				return false;
			}
		}
	}
	
	function get_agent_kharch_payment_description($agent_id)
	{
		$status='pending';
		if($stmt_select = $this->con->prepare("SELECT `description` FROM `kharch` WHERE `agent_id`=?  AND `status`=?"))
		{
			$stmt_select->bind_param("ss",$agent_id,$status);
			
			$stmt_select->bind_result($description);
			
			if($stmt_select->execute())
			{
			    $data   =   array();
			    $counter = 0;
			    $value =  "";
				while($stmt_select->fetch())
				{
				    if($value=="")
				    {
				        $value  =   $description;
				    }
				    else
				    {
				        $value  =   $value.",".$description;
				    }
				}
				
				if($value!="")
				{
				    return $value;
				}
				return false;
			}
		}
	}
	
	function update_kharch_status($post_agent_id)
	{
		if($stmt = $this->con->prepare("UPDATE `kharch` SET `status`='yes' WHERE `agent_id`=?"))
		{ 
			$stmt->bind_param("s",$post_agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	function get_final_text_status_of_user($agent_id)
	{
		
		if($stmt_select = $this->con->prepare("SELECT `final_text` FROM `agents_transaction` WHERE `agent_id`=? ORDER BY `id` DESC"))
		{
			$stmt_select->bind_param("s",$agent_id);
			
			$stmt_select->bind_result($name);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $name;
				}
				return false;
			}
		}
	}
	function get_credit_report($tdate)
	{
		$date_data	=	explode("-",$tdate);
		$tdate	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];

		if($stmt = $this->con->prepare("SELECT `id`, `market_id`, `search_date`, `agent_id`, `sutta_agent_total_amount`, `sutta_agent_commision_rate`, `sutta_agent_win_amount`, `jent_agent_total_amount`, `jent_agent_commision_rate`, `jent_agent_win_amount`, `close_agent_total_amount`, `close_agent_commision_rate`, `close_agent_win_amount`, `open_pana_total_amount`, `open_pana_commsion_rate`, `open_pana_win_amount`, `close_pana_total_amount`, `close_pana_commsion_rate`, `close_pana_win_amount`, `ekun_sutta_jent_close_open_pana`, `agent_commision`, `agent_rokadi`, `total_of_all`, `open`, `close`, `ekun_open_close`, `nava_jama_text`, `nave_jama_amount`, `total`, `final_text`, `final_total`, `date`, `time`, `transaction_type`, `rokadi_status`,`added_by`,`khadi`,`khadi_lavalele`, `agent_kharch` FROM `agents_transaction` WHERE  `final_text`='जमा' AND `date`=?"))
		{
			$stmt->bind_param("s",$tdate);
			
			$stmt->bind_result($res_id,$post_business_title,$post_search_date,$post_agent_id,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$date,$time,$transaction_type,$rokadi_status,$added_by,$khadi,$khadi_lavalele,$agent_kharch);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$counter][0]	=	$res_id;
					$data[$counter][1]	=	$post_business_title;
					$data[$counter][2]	=	$post_search_date;
					$data[$counter][3]	=	$post_agent_id;
					$data[$counter][4]	=	$post_sutta_amount;
					$data[$counter][5]	=	$post_sutta_rate;
					$data[$counter][6]	=	$post_sutta_win_amount;
					$data[$counter][7]	=	$post_jent_amount;
					$data[$counter][8]	=	$post_jent_rate;
					$data[$counter][9]	=	$post_jent_win_amount;
					$data[$counter][10]	=	$post_close_amount;
					$data[$counter][11]	=	$post_close_rate;
					$data[$counter][12]	=	$post_close_win_amount;
					$data[$counter][13]	=	$post_pana_open_amount;
					$data[$counter][14]	=	$post_pana_open_rate;
					$data[$counter][15]	=	$post_pana_open_win_amount;
					$data[$counter][16]	=	$post_pana_close_amount;
					$data[$counter][17]	=	$post_pana_close_rate;
					$data[$counter][18]	=	$post_pana_close_win_amount;
					$data[$counter][19]	=	$post_ekum_amount;
					$data[$counter][20]	=	$post_total_commision;
					$data[$counter][21]	=	$post_total_rokadi_amount;
					$data[$counter][22]	=	$post_total;
					$data[$counter][23]	=	$post_open;
					$data[$counter][24]	=	$post_close;
					$data[$counter][25]	=	$post_total_open_close;
					$data[$counter][26]	=	$post_current_nave_jama_text;
					$data[$counter][27]	=	$post_current_nave_jama_amount;
					$data[$counter][28]	=	$post_current_total;
					$data[$counter][29]	=	$post_final_jama_nave_text;
					$data[$counter][30]	=	$post_final_jama_nave_amount;
					$data[$counter][31]	=	$date;
					$data[$counter][32]	=	$time;
					$data[$counter][33]	=	$transaction_type;
					$data[$counter][34]	=	$rokadi_status;
					$data[$counter][35]	=	$added_by;
					$data[$counter][36]	=	$khadi;
					$data[$counter][37]	=	$khadi_lavalele;
					$data[$counter][38]	=	$agent_kharch;
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_debit_report($tdate)
	{
		$date_data	=	explode("-",$tdate);
		$tdate	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `id`, `market_id`, `search_date`, `agent_id`, `sutta_agent_total_amount`, `sutta_agent_commision_rate`, `sutta_agent_win_amount`, `jent_agent_total_amount`, `jent_agent_commision_rate`, `jent_agent_win_amount`, `close_agent_total_amount`, `close_agent_commision_rate`, `close_agent_win_amount`, `open_pana_total_amount`, `open_pana_commsion_rate`, `open_pana_win_amount`, `close_pana_total_amount`, `close_pana_commsion_rate`, `close_pana_win_amount`, `ekun_sutta_jent_close_open_pana`, `agent_commision`, `agent_rokadi`, `total_of_all`, `open`, `close`, `ekun_open_close`, `nava_jama_text`, `nave_jama_amount`, `total`, `final_text`, `final_total`, `date`, `time`, `transaction_type`, `rokadi_status`,`added_by`,`khadi`,`khadi_lavalele`, `agent_kharch`FROM `agents_transaction` WHERE  `final_text`='नावे'  AND `date`=?"))
			
		{
			
			$stmt->bind_param("s",$tdate);
			
			$stmt->bind_result($res_id,$post_business_title,$post_search_date,$post_agent_id,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$date,$time,$transaction_type,$rokadi_status,$added_by,$khadi,$khadi_lavalele,$agent_kharch);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$counter][0]	=	$res_id;
					$data[$counter][1]	=	$post_business_title;
					$data[$counter][2]	=	$post_search_date;
					$data[$counter][3]	=	$post_agent_id;
					$data[$counter][4]	=	$post_sutta_amount;
					$data[$counter][5]	=	$post_sutta_rate;
					$data[$counter][6]	=	$post_sutta_win_amount;
					$data[$counter][7]	=	$post_jent_amount;
					$data[$counter][8]	=	$post_jent_rate;
					$data[$counter][9]	=	$post_jent_win_amount;
					$data[$counter][10]	=	$post_close_amount;
					$data[$counter][11]	=	$post_close_rate;
					$data[$counter][12]	=	$post_close_win_amount;
					$data[$counter][13]	=	$post_pana_open_amount;
					$data[$counter][14]	=	$post_pana_open_rate;
					$data[$counter][15]	=	$post_pana_open_win_amount;
					$data[$counter][16]	=	$post_pana_close_amount;
					$data[$counter][17]	=	$post_pana_close_rate;
					$data[$counter][18]	=	$post_pana_close_win_amount;
					$data[$counter][19]	=	$post_ekum_amount;
					$data[$counter][20]	=	$post_total_commision;
					$data[$counter][21]	=	$post_total_rokadi_amount;
					$data[$counter][22]	=	$post_total;
					$data[$counter][23]	=	$post_open;
					$data[$counter][24]	=	$post_close;
					$data[$counter][25]	=	$post_total_open_close;
					$data[$counter][26]	=	$post_current_nave_jama_text;
					$data[$counter][27]	=	$post_current_nave_jama_amount;
					$data[$counter][28]	=	$post_current_total;
					$data[$counter][29]	=	$post_final_jama_nave_text;
					$data[$counter][30]	=	$post_final_jama_nave_amount;
					$data[$counter][31]	=	$date;
					$data[$counter][32]	=	$time;
					$data[$counter][33]	=	$transaction_type;
					$data[$counter][34]	=	$rokadi_status;
					$data[$counter][35]	=	$added_by;
					$data[$counter][36]	=	$khadi;
					$data[$counter][37]	=	$khadi_lavalele;
					$data[$counter][38]	=	$agent_kharch;
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_agent_data_from_userid($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`,`user_id`, `password`, `date`, `time` FROM `agent` where `user_id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[4]	=	$commission;
					$data[5]	=	$user_id;
					$data[6]	=	$password;
					$data[7]	=	$date;
					$data[8]	=	$time;
					
					
					return $data;
				}
			}
			return false;
		}
	}
	
	
	function get_agent_data_from_userid_for_sleep($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`,`user_id`, `password`, `date`, `time` FROM `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[4]	=	$commission;
					$data[5]	=	$user_id;
					$data[6]	=	$password;
					$data[7]	=	$date;
					$data[8]	=	$time;
					
					
					return $data;
				}
			}
			return false;
		}
	}
	
	
	function get_agent_numeric_id_from_userid($agent_id)
	{
		
		if($stmt = $this->con->prepare("SELECT `id` FROM `agent` WHERE `user_id`=?"))
		{
			
			$stmt->bind_param("s",$agent_id);
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
						
					return $res_id;
				}
				return false;
			}
		}
	}
	
	function get_credit_debitreport($tdate,$agent_id)
	{
		//$date_data	=	explode("-",$tdate);
		//$tdate	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
	
		if($stmt = $this->con->prepare("SELECT `id`, `market_id`, `search_date`, `agent_id`, `sutta_agent_total_amount`, `sutta_agent_commision_rate`, `sutta_agent_win_amount`, `jent_agent_total_amount`, `jent_agent_commision_rate`, `jent_agent_win_amount`, `close_agent_total_amount`, `close_agent_commision_rate`, `close_agent_win_amount`, `open_pana_total_amount`, `open_pana_commsion_rate`, `open_pana_win_amount`, `close_pana_total_amount`, `close_pana_commsion_rate`, `close_pana_win_amount`, `ekun_sutta_jent_close_open_pana`, `agent_commision`, `agent_rokadi`, `total_of_all`, `open`, `close`, `ekun_open_close`, `nava_jama_text`, `nave_jama_amount`, `total`, `final_text`, `final_total`, `date`, `time`, `transaction_type`, `rokadi_status`,`added_by`,`khadi`,`khadi_lavalele`, `agent_kharch` FROM `agents_transaction` WHERE `search_date`=? AND `agent_id`=? ORDER BY `id` DESC LIMIT 1 "))
		{
			
			$stmt->bind_param("ss",$tdate,$agent_id);
			
			$stmt->bind_result($res_id,$post_business_title,$post_search_date,$post_agent_id,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$date,$time,$transaction_type,$rokadi_status,$added_by,$khadi,$khadi_lavalele,$agent_kharch);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$counter][0]	=	$res_id;
					$data[$counter][1]	=	$post_business_title;
					$data[$counter][2]	=	$post_search_date;
					$data[$counter][3]	=	$post_agent_id;
					$data[$counter][4]	=	$post_sutta_amount;
					$data[$counter][5]	=	$post_sutta_rate;
					$data[$counter][6]	=	$post_sutta_win_amount;
					$data[$counter][7]	=	$post_jent_amount;
					$data[$counter][8]	=	$post_jent_rate;
					$data[$counter][9]	=	$post_jent_win_amount;
					$data[$counter][10]	=	$post_close_amount;
					$data[$counter][11]	=	$post_close_rate;
					$data[$counter][12]	=	$post_close_win_amount;
					$data[$counter][13]	=	$post_pana_open_amount;
					$data[$counter][14]	=	$post_pana_open_rate;
					$data[$counter][15]	=	$post_pana_open_win_amount;
					$data[$counter][16]	=	$post_pana_close_amount;
					$data[$counter][17]	=	$post_pana_close_rate;
					$data[$counter][18]	=	$post_pana_close_win_amount;
					$data[$counter][19]	=	$post_ekum_amount;
					$data[$counter][20]	=	$post_total_commision;
					$data[$counter][21]	=	$post_total_rokadi_amount;
					$data[$counter][22]	=	$post_total;
					$data[$counter][23]	=	$post_open;
					$data[$counter][24]	=	$post_close;
					$data[$counter][25]	=	$post_total_open_close;
					$data[$counter][26]	=	$post_current_nave_jama_text;
					$data[$counter][27]	=	$post_current_nave_jama_amount;
					$data[$counter][28]	=	$post_current_total;
					$data[$counter][29]	=	$post_final_jama_nave_text;
					$data[$counter][30]	=	$post_final_jama_nave_amount;
					$data[$counter][31]	=	$date;
					$data[$counter][32]	=	$time;
					$data[$counter][33]	=	$transaction_type;
					$data[$counter][34]	=	$rokadi_status;
					$data[$counter][35]	=	$added_by;
					$data[$counter][36]	=	$khadi;
					$data[$counter][37]	=	$khadi_lavalele;
					$data[$counter][38]	=	$agent_kharch;
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_all_agents()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `user_id`, `password`, `date`, `time` FROM `agent` "))
		{
			
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$user_id;
					$data[$cntr][6]	=	$password;
					$data[$cntr][7]	=	$date;
					$data[$cntr][8]	=	$time;
					
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	
	}
	function get_winner_aakda_cc($aakda_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `aakda` FROM `winner_aakda` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `winner_date`=?"))
		{
			
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_aakda);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{	
					return $res_aakda;
				}
			}
			return false;
		}
	}
	function update_agent_new_password($new_password,$email)
	{
		
		if($stmt = $this->con->prepare("UPDATE `agent` SET `password`=? WHERE `user_id`=?"))
		{
			$stmt->bind_param("ss",$new_password,$email);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	//30-11-2019
	function get_customer_password($user_id)
	{
		if($stmt = $this->con->prepare("SELECT `password` FROM `agents_customer` WHERE `user_id` = ?"))
		{
			$stmt->bind_param("s",$user_id);
			
			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
				    
				    return $res_password;
				    
				}
				return false;
			}
		}
	}
	function add_agents_customer_details($agent_id,$customer_name,$cust_mob_no,$user_id,$password)
	{
			$date = date("Y-m-d");
			$time = date("H:i:s A");
			$account_status="";
			if($stmt = $this->con->prepare("INSERT INTO `agents_customer`(`agent_id`, `customer_name`, `cust_mob_no`, `user_id`, `password`, `date`, `time`, `account_status`) VALUES  (?,?,?,?,?,?,?,?)"))
			{
				$stmt->bind_param("ssssssss",$agent_id,$customer_name,$cust_mob_no,$user_id,$password,$date,$time,$account_status);
				
				if($stmt->execute())
				{
					return $stmt->insert_id;
				}
			}
			return false;
	}
	function update_agents_customer_details($customer_name,$cust_mob_no,$customer_user_id,$password,$customer_id)
	{
			$date = date("Y-m-d");
			$time = date("H:i:s A");
			
			if($stmt = $this->con->prepare("UPDATE `agents_customer` SET `customer_name`=? ,`cust_mob_no`=? ,`date`=?,`time`=?,`user_id`=?,`password`=? WHERE `id`=?"))
			{
				$stmt->bind_param("sssssss",$customer_name,$cust_mob_no,$date,$time,$customer_user_id,$password,$customer_id);
				
				if($stmt->execute())
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			return false;
	}
	function delete_agents_customer_details($customer_id)
	{
		if($stmt = $this->con->prepare("Delete from `agents_customer` where `id` = ?"))
		{
			$stmt->bind_param("i",$customer_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_complete_cutomer_report_by_agent_id($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `customer_name`, `cust_mob_no`, `user_id`, `password`, `date`, `time`, `account_status` FROM `agents_customer` WHERE `agent_id`=? "))
		{
			
			$stmt->bind_param("s",$agent_id);
			$stmt->bind_result($res_id,$agent_id,$customer_name,$cust_mob_no,$user_id,$password,$date,$time,$account_status);
			
			if($stmt->execute())
			{
			    $data = array(); 
			    $counter = 0;
				while($stmt->fetch())
				{
				    $data[$counter][0]				=	$res_id;
					$data[$counter][1]				=	$agent_id;
					$data[$counter][2]				=	$customer_name;
					$data[$counter][3]				=	$cust_mob_no;
					$data[$counter][4]				=	$user_id;
					$data[$counter][5]				=	$password;
					$data[$counter][6]				=	$date;
					$data[$counter][7]				=	$time;
					$data[$counter][8]				=	$account_status;
					
					
					$counter++;
				}
				
				if(!empty($data))
				{
            		return $data;
				}
				else
				{
                    return false;
				}
			}
		}
	}
	function get_customer_data_from_id($customer_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `customer_name`, `cust_mob_no`, `user_id`, `password`, `date`, `time`, `account_status` FROM `agents_customer` WHERE `id`=? "))
		{
			
			$stmt->bind_param("i",$customer_id);
			$stmt->bind_result($res_id,$agent_id,$customer_name,$cust_mob_no,$user_id,$password,$date,$time,$account_status);
			
			if($stmt->execute())
			{
			    $data = array(); 
			    $counter = 0;
				if($stmt->fetch())
				{
				    $data[0]				=	$res_id;
					$data[1]				=	$agent_id;
					$data[2]				=	$customer_name;
					$data[3]				=	$cust_mob_no;
					$data[4]				=	$user_id;
					$data[5]				=	$password;
					$data[6]				=	$date;
					$data[7]				=	$time;
					$data[8]				=	$account_status;
					
					return $data;
				}
				else
				{
                    return false;
				}
			}
		}
	}
	function get_customer_password_for_edit($customer_user_id,$customer_id)
	{
		if($stmt = $this->con->prepare("Select `password` from `agents_customer` where `user_id` = ? AND `id`!=?"))
		{
			$stmt->bind_param("si",$customer_user_id,$customer_id);

			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
			}
			return false;
		}
	}
	function update_customer_new_password($new_password,$email)
	{
		
		if($stmt = $this->con->prepare("UPDATE `agents_customer` SET `password`=? WHERE `user_id`=?"))
		{
			$stmt->bind_param("ss",$new_password,$email);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_agent_user_id($added_by)
	{
		
		if($stmt = $this->con->prepare("SELECT `agent_id` FROM `agents_customer` WHERE `user_id`=?"))
		{
			$stmt->bind_param("s",$added_by);

			$stmt->bind_result($res_agent_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_agent_id;
				}
			}
			return false;
		}
	}
	function get_customer_id($added_by)
	{
		if($stmt = $this->con->prepare("SELECT  `id` FROM `agents_customer` WHERE `user_id`=?"))
		{
			$stmt->bind_param("s",$added_by);

			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
			}
			return false;
		}
	}
	function save_customer_aakda($sel_agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$customer_id,$date)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `customer_aakade`(`buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`,`agent_id`) VALUES (?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssss",$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$date,$time,$customer_id,$sel_agent_name);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_last_paise_of_customer($customer_id)
	{
		$date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("Select `paise` from `customer_aakade` where `added_by` = ? AND `date` = ? ORDER By `id` DESC"))
		{
			$stmt->bind_param("ss",$customer_id,$date);

			$stmt->bind_result($res_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_paise;
				}
			}
			return false;
		}
	}
	function delete_customer_aakda($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `customer_aakade` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	 function get_todays_aakde_data_by_select_title_customer_side($buisness_main_title,$buisness_sub_title,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$query_stmt	=	"";
		if($buisness_sub_title=="ALL")
		{
			$query_stmt="";
		}
		else 
		{
			
			$query_stmt="AND `buisness_sub_title` = '".$buisness_sub_title."'";
		}
		
		if($stmt = $this->con->prepare("SELECT `id`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `customer_aakade` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND  `date`=? ".$query_stmt." ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("s",$search_date);

			$stmt->bind_result($id,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$buisness_main_title;
					$data[$cntr][2]	=	$buisness_sub_title;
					$data[$cntr][3]	=	$aakda;
					$data[$cntr][4]	=	$paise;
					$data[$cntr][5]	=	$date;
					$data[$cntr][6]	=	$time;
					$data[$cntr][7]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function update_customer_aakda($buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$customer_id,$edit_aakda)
	{
		
		if($stmt = $this->con->prepare("UPDATE `customer_aakade` SET `buisness_main_title`=?,`buisness_sub_title`=?,`aakda`=?,`paise`=?,`added_by`=? WHERE `id`=?"))
		{
			
			$stmt->bind_param("sssssi",$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$customer_id,$edit_aakda);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_aakde_data_from_id_customer($edit_aakda)
	{
		$todays_date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("SELECT `id`,`buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `customer_aakade` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$edit_aakda);

			$stmt->bind_result($id,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function get_customer_name($added_by)
	{
		if($stmt = $this->con->prepare("SELECT  `customer_name` FROM `agents_customer` WHERE `id`=?"))
		{
			$stmt->bind_param("s",$added_by);

			$stmt->bind_result($res_customer_name);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_customer_name;
				}
			}
			return false;
		}
	}
	function get_customer_details_by_agent_id($userid)
	{
	    
		if($stmt = $this->con->prepare("SELECT `id`,`customer_name` FROM `agents_customer` WHERE `agent_id`=?"))
		{
			$stmt->bind_param("s",$userid);
			$stmt->bind_result($res_id,$customer_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$customer_name;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	 function get_todays_aakde_data_by_select_title_agent_side($agent_id,$buisness_main_title,$buisness_sub_title,$taarikh,$customer_name)
	{
		
		$date_data	=	explode("-",$taarikh);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$query_stmt	=	"";
		if($buisness_sub_title=="ALL")
		{
			$query_stmt="";
		}
		else 
		{
			
			$query_stmt="AND `buisness_sub_title` = '".$buisness_sub_title."'";
		}
		
		if($stmt = $this->con->prepare("SELECT `id`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `customer_aakade` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND  `date`=?  AND `agent_id`=? AND `added_by`=? ".$query_stmt." ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("sss",$search_date,$agent_id,$customer_name);

			$stmt->bind_result($id,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$buisness_main_title;
					$data[$cntr][2]	=	$buisness_sub_title;
					$data[$cntr][3]	=	$aakda;
					$data[$cntr][4]	=	$paise;
					$data[$cntr][5]	=	$date;
					$data[$cntr][6]	=	$time;
					$data[$cntr][7]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function get_aakde_data_from_id_custome_akade_table($edit_aakda)
	{
		$todays_date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("SELECT `id`,`buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `customer_aakade` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$edit_aakda);

			$stmt->bind_result($id,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				if($stmt->fetch())
				{
					$data[0]	=	$id;
					$data[2]	=	$buisness_main_title;
					$data[3]	=	$buisness_sub_title;
					$data[4]	=	$aakda;
					$data[5]	=	$paise;
					$data[6]	=	$date;
					$data[7]	=	$time;
					$data[8]	=	$added_by;
					
					return $data;
				}
			}
			else
			{
				return false;
			}
		}
	}
	function save_customer_aakade_by_agent($agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$date,$customer_id)
	{
		$date=date("Y-m-d");
		//$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `agent_aakde`(`agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`,`customer_id`) VALUES (?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssssss",$agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$date,$time,$added_by,$customer_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	 function get_aakde_data_for_customer_played_report($customer_id,$taarikh,$aakda,$buisness_main_title,$buisness_sub_title)
	{
	
	    	$stmt = "";
		if($customer_id=="सर्व दाखवा")
		{
			$customer_id	=	"";
			$stmt = " AND `customer_id` LIKE '%%'";
		}
		else if($customer_id!="")
		{
			$stmt = " AND `customer_id`='".$customer_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
		if($aakda!="")
		{
			$stmt = $stmt." AND `aakda` = '".$aakda."' ";
		}
			
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`,`customer_id` FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt." ORDER BY `id` ASC "))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by,$customer_id);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					$data[$cntr][9]	=	$customer_id;
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function delete_customer_aakda_from_agent_table($del_id)
	{
		
		if($stmt = $this->con->prepare("Delete from `agent_aakde` where `id` = ?"))
		{
			
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_customer_id_from_table($customer_id)
	{
		if($stmt_select = $this->con->prepare("SELECT  `id` FROM `agents_customer` WHERE `user_id`=? "))
			{
				$stmt_select->bind_param("s",$customer_id);
				
				$stmt_select->bind_result($res_cust_name);
				
				if($stmt_select->execute())
				{
					if($stmt_select->fetch())
					{
						return $res_cust_name;
					}
					return false;
				}
			}
	}
	//4-8-2020
	function get_type_related_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_id,$type)
	{
		
		$date_data	=	explode("-",$searched_date);
		
		$searched_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
	
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda`=? AND `agent`=?  AND  `type`=?  AND CHAR_LENGTH(`aakda`)=1   "))
		{
			
		   
			$stmt->bind_param("sss",$passed_val,$agent_id,$type);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
//6-8-2020
	function get_number_setting_details()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `single`, `double`, `single_pana`, `double_pana`, `triple_pana` , `m_single`, `m_double`, `m_single_pana`, `m_double_pana`, `m_triple_pana`,`kn_single`, `kn_jodi`, `kn_single_pana`, `kn_double_pana`, `kn_triple_pana` FROM `number_setting` "))
		{
			$stmt->bind_result($res_id,$single,$double,$single_pana,$double_pana,$triple_pana,$m_single,$m_double,$m_single_pana,$m_double_pana,$m_triple_pana,$kn_single,$kn_jodi,$kn_single_pana,$kn_double_pana,$kn_triple_pana);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$single;
					$data[2]	=	$double;
					$data[3]	=	$single_pana;
					$data[4]	=	$double_pana;
					$data[5]	=	$triple_pana;
					$data[6]	=	$m_single;
					$data[7]	=	$m_double;
					$data[8]	=	$m_single_pana;
					$data[9]	=	$m_double_pana;
					$data[10]	=	$m_triple_pana;
					$data[11]	=	$kn_single;
					$data[12]	=	$kn_jodi;
					$data[13]	=	$kn_single_pana;
					$data[14]	=	$kn_double_pana;
					$data[15]	=	$kn_triple_pana;
					
					return $data;
				}
			}
			return false;
		}
	}
	function update_number($single,$jodi,$single_pana,$double_pana,$triple_pana,$m_single,$m_jodi,$m_single_pana,$m_double_pana,$m_triple_pana,$kn_single,$kn_jodi,$kn_single_pana,$kn_double_pana,$kn_triple_pana)
	{
		$date	=	date("Y-m-d");
		$time 	= 	date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `number_setting` SET  `single`=?,`double`=?,`single_pana`=?,`double_pana`=?,`triple_pana`=?,`date`=?,`time`=?,`m_single`=?,`m_double`=?,`m_single_pana`=?,`m_double_pana`=?,`m_triple_pana`=?,`kn_single`=?,`kn_jodi`=?,`kn_single_pana`=?,`kn_double_pana`=?,`kn_triple_pana`=?"))
		{
			$stmt->bind_param("sssssssssssssssss",$single,$jodi,$single_pana,$double_pana,$triple_pana,$date,$time,$m_single,$m_jodi,$m_single_pana,$m_double_pana,$m_triple_pana,$kn_single,$kn_jodi,$kn_single_pana,$kn_double_pana,$kn_triple_pana);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	//FAMILY
	function get_family_chart_record($winner_pana_open)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `chart` FROM `family_pana_chart` WHERE `chart` LIKE '%".$winner_pana_open."%' "))
		{
			$stmt->bind_result($res_id,$chart);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$chart;
					return $data;
				}
			}
			return false;
		}
	}
	function get_family_type_related_data($buisness_main_title,$buisness_sub_title,$searched_date,$chart_data,$agent_id,$type)
	{
		
		$date_data	=	explode("-",$searched_date);
		
		$searched_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
	
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `agent`=? AND `type`=? AND CHAR_LENGTH(`aakda`)=3 AND `aakda` IN ($chart_data) "))
		{
			
		  
			$stmt->bind_param("ss",$agent_id,$type);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_ring_numbers($buisness_main_title,$searched_date,$agent_id,$type)
	{
		
		$date_data	=	explode("-",$searched_date);
		
		$searched_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		if($stmt = $this->con->prepare("SELECT `aakda` , `paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%'  AND `date`='".$searched_date."' AND `agent`=?  AND  `type`=?"))
		{
			 $stmt->bind_param("ss",$agent_id,$type);
			
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$aakda;
					$data[$cntr][1]	=	$paise;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_cp_type_related_data($buisness_main_title,$buisness_sub_title,$searched_date,$agent_id,$type)
	{
		
		$date_data	=	explode("-",$searched_date);
		
		$searched_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		if($stmt = $this->con->prepare("SELECT `aakda` , `paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `agent`=?  AND  `type`=?"))
		{
			 $stmt->bind_param("ss",$agent_id,$type);
			
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$aakda;
					$data[$cntr][1]	=	$paise;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_agent_total_amount_table_from_total_column($select_buisness_main_title,$sub_title,$today_date,$agent_id)
	{
		$date_data	=	explode("-",$today_date);
		$today_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
	
		if($stmt = $this->con->prepare("SELECT SUM(`total_amount`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$select_buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$sub_title."%' AND `date`='".$today_date."' AND `agent` =?"))
		{
			
			$stmt->bind_param("s",$agent_id);
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	//8-8-2020
    function save_nave_jama($post_agent_id,$post_business_title,$post_final_jama_nave_text,$post_final_jama_nave_amount,$post_search_date)
    {
    		$date=date("Y-m-d");
    		$time = date("h:i:s A");
    		$added_by   =   "";
    		$rokadi_status		=	"used";
    		$post_sutta_amount	=	"";
    		$post_sutta_rate	=	"";
    		$post_sutta_win_amount	="";
    		$post_jent_amount	=	"";
    		$post_jent_rate		=	"";
    		$post_jent_win_amount="";
    		$post_close_amount	=	"";
    		$post_close_rate	=	"";
    		$post_close_win_amount	="";
    		$post_pana_open_amount	="";
    		$post_pana_open_rate	=	"";
    		$post_pana_open_win_amount	="";
    		$post_pana_close_amount	="";
    		$post_pana_close_rate	="";
    		$post_pana_close_win_amount	="";
    		$post_ekum_amount		="";
    		$post_total_commision	=	"";
    		$post_total				=	"";
    		$post_open				=	"";
    		$post_close				=	"";
    		$post_total_open_close	=	"";
    		$post_current_total		=	"";
    		$khadi					=	"";
    		$khadi_lavalele			=	"";
    		$agent_kharch			=	"";
    		$post_total_rokadi_amount=	"";
    		$post_current_nave_jama_text="";
    		$post_current_nave_jama_amount="";
    		$transaction_type		=	"";
    		$post_khadi				="";
    		$agent_kadi_lavalele	=	"";
    		 $post_final_sp_amount	=	"";
    		  $post_final_dp_amount	=	"";
    		  $post_final_tp_amount	=	"";
    		  $post_final_cp_amount	=	"";
    		  $post_final_family_amount="";
    		  $post_total_ring_amount=	"";
    		if($stmt = $this->con->prepare("INSERT INTO `agents_transaction`(`market_id`, `search_date`, `agent_id`, `sutta_agent_total_amount`, `sutta_agent_commision_rate`, `sutta_agent_win_amount`, `jent_agent_total_amount`, `jent_agent_commision_rate`, `jent_agent_win_amount`, `close_agent_total_amount`, `close_agent_commision_rate`, `close_agent_win_amount`, `open_pana_total_amount`, `open_pana_commsion_rate`, `open_pana_win_amount`, `close_pana_total_amount`, `close_pana_commsion_rate`, `close_pana_win_amount`, `ekun_sutta_jent_close_open_pana`, `agent_commision`, `agent_rokadi`, `total_of_all`, `open`, `close`, `ekun_open_close`, `nava_jama_text`, `nave_jama_amount`, `total`, `final_text`, `final_total`, `date`, `time`,`transaction_type`,`rokadi_status`,`khadi`,`khadi_lavalele`,`agent_kharch`,`added_by`,`sp_amount`, `dp_amount`, `tp_amount`, `cp_amount`, `family_amount`, `ring_amount`) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
    		{
    			
    			$stmt->bind_param("ssssssssssssssssssssssssssssssssssssssssssss",$post_business_title,$post_search_date,$post_agent_id,$post_sutta_amount,$post_sutta_rate ,$post_sutta_win_amount,$post_jent_amount,$post_jent_rate,$post_jent_win_amount,$post_close_amount,$post_close_rate,$post_close_win_amount,$post_pana_open_amount,$post_pana_open_rate,$post_pana_open_win_amount,$post_pana_close_amount,$post_pana_close_rate,$post_pana_close_win_amount,$post_ekum_amount,$post_total_commision,$post_total_rokadi_amount,$post_total,$post_open,$post_close,$post_total_open_close,$post_current_nave_jama_text,$post_current_nave_jama_amount,$post_current_total,$post_final_jama_nave_text,$post_final_jama_nave_amount,$date,$time,$transaction_type,$rokadi_status,$post_khadi,$agent_kadi_lavalele,$agent_kharch,$added_by,$post_final_sp_amount,$post_final_dp_amount,$post_final_tp_amount,$post_final_cp_amount,$post_final_family_amount,$post_total_ring_amount);
    			
    			if($stmt->execute())
    			{
    				return true;
    			}
    			return false;
    		}	
    }
    function update_nave_jama($agent_name,$buisness_main_title,$transaction_type,$amount,$tarikh,$up_id)
    {
    	$date=date("Y-m-d");
    	$time = date("h:i:s A");
    	
    	if($stmt = $this->con->prepare("UPDATE `agents_transaction` SET `agent_id`=?,`market_id`=?,`final_text`=?,`final_total`=?,`search_date`=?,`date`=?,`time`=? WHERE `id`=?"))
    	{
    		$stmt->bind_param("sssssssi",$agent_name,$buisness_main_title,$transaction_type,$amount,$tarikh,$date,$time,$up_id);
    		
    		if($stmt->execute())
    		{
    			return true;
    		}
    		return false;
    	}
    }
    function get_type_related_data_tp($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_id,$type)
	{
		
		$date_data	=	explode("-",$searched_date);
		
		$searched_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
	
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda`=? AND `agent`=?  AND  `type`=?  AND CHAR_LENGTH(`aakda`)=3   "))
		{
			
		   
			$stmt->bind_param("sss",$passed_val,$agent_id,$type);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	//16-8-2020NEW
	function get_station_id($station_name)
	{
			if($stmt = $this->con->prepare("SELECT `id` FROM `police_station_master` WHERE `station_name`=?"))
			{
				$stmt->bind_param("s",$station_name);
				
				$stmt->bind_result($res_id);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_id;
					}
					return False;
				}
			}
	}
	
	function get_market_id($station_name)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `market` WHERE `market_name`=?"))
		{
			$stmt->bind_param("s",$station_name);
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
				return False;
			}
		}
	}
	
	function register_police_station_master($station_name)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `police_station_master`(`station_name`, `date`, `time`) VALUES(?,?,?)"))
		{
			
			$stmt->bind_param("sss",$station_name,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function register_new_market_master($station_name)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `market`(`market_name`, `date`, `time`) VALUES(?,?,?)"))
		{			
			$stmt->bind_param("sss",$station_name,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_police_station_detail()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `station_name` FROM `police_station_master`"))
		{
			
		  $stmt->bind_result($res_id,$station_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$station_name;
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_market_all_detail()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `market_name` FROM `market`"))
		{			
		  $stmt->bind_result($res_id,$station_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$station_name;
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function delete_station_master($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `police_station_master` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_new_market($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `market` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_police_station_master($station_name,$up_id)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `police_station_master` SET `station_name`=?  WHERE `id`=?"))
		{
			$stmt->bind_param("si",$station_name,$up_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_market_master($station_name,$up_id)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `market` SET `market_name`=?  WHERE `id`=?"))
		{
			$stmt->bind_param("si",$station_name,$up_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_station_master_data_from_id($up_id)
	{
		
		if($stmt = $this->con->prepare("SELECT `id`, `station_name` FROM `police_station_master` WHERE `id`=?"))
		{
			
			$stmt->bind_param("i",$up_id);
			
			$stmt->bind_result($res_id,$station_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$station_name;
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_market_data_from_id($up_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `market_name` FROM `market` WHERE `id`=?"))
		{			
			$stmt->bind_param("i",$up_id);
			
			$stmt->bind_result($res_id,$station_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$station_name;
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_station_id_fro_update($station_name,$up_id)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `police_station_master` WHERE `station_name`=? AND `id`!=?"))
		{
			$stmt->bind_param("si",$station_name,$up_id);
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
				return False;
			}
		}
	}
	
	function get_market_name_from_id_new_one($market_id)
	{
		if($stmt = $this->con->prepare("SELECT `market_name` FROM `market` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$market_id);
			
			$stmt->bind_result($res_market_name);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_market_name;
				}
				return False;
			}
		}
	}
	
	function get_market_id_fro_update($station_name,$up_id)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `market` WHERE `market_name`=? AND `id`!=?"))
		{
			$stmt->bind_param("si",$station_name,$up_id);
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
				return False;
			}
		}
	}
	
	function get_police_station_name($up_id)
	{
		if($stmt = $this->con->prepare("SELECT `station_name` FROM `police_station_master` WHERE  `id`=?"))
		{
			$stmt->bind_param("i",$up_id);
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
				return False;
			}
		}
	}
	//16-8-2020VASULI VATAP
	function get_vasuli_vatap_data_admin_by_id($up_id)
	{
		
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `rokadi`, `transaction_type`, `added_by`, `status`, `date`, `time`,`type` FROM `agent_rokadi` WHERE `id`=? "))
		{
			
			$stmt->bind_param("i",$up_id);
			
			$stmt->bind_result($res_id,$agent_id,$amount,$transaction_type,$added_by,$status,$date,$time,$type);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					
					$data[0]	=	$res_id;
					$data[1]	=	$agent_id;
					$data[2]	=	$amount;
					$data[3]	=	$transaction_type;
					$data[4]	=	$added_by;
					$data[5]	=	$status;
					$data[6]	=	$date;
					$data[7]	=	$time;
					$data[8]	=	$type;
					
					return $data;
				}
				else
				{
					return false;
				}
			}
			
		}
	}
	function update_vasuli_vatap_amount($amount,$up_id)
	{
		$date=date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `agent_rokadi` SET `rokadi`=?  WHERE `id`=?"))
		{
			$stmt->bind_param("si",$amount,$up_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	//7-9-2020
	function get_agent_chuk_nave_amount($agent_id)
	{
		$status='pending';
		if($stmt_select = $this->con->prepare("SELECT SUM(`amount`) FROM `chuk_rakkam` WHERE `agent_id`=?  AND `status`=?"))
		{
			$stmt_select->bind_param("ss",$agent_id,$status);
			
			$stmt_select->bind_result($name);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $name;
				}
				return false;
			}
		}
	}
	
	function get_chuk_dene_amount($agent_id)
	{
		$status='pending';
		if($stmt_select = $this->con->prepare("SELECT SUM(`amount`) FROM `chuk_rakkam_dene_agentla` WHERE `agent_id`=?  AND `status`=?"))
		{
			$stmt_select->bind_param("ss",$agent_id,$status);
			
			$stmt_select->bind_result($amount);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $amount;
				}
				return false;
			}
		}
	}
	
	function update_chuk_nave_status($post_agent_id)
	{
		if($stmt = $this->con->prepare("UPDATE `chuk_rakkam` SET `status`='yes' WHERE `agent_id`=?"))
		{ 
			$stmt->bind_param("s",$post_agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	
	function update_chuk_dene_status($post_agent_id)
	{
		if($stmt = $this->con->prepare("UPDATE `chuk_rakkam_dene_agentla` SET `status`='yes' WHERE `agent_id`=?"))
		{
			$stmt->bind_param("s",$post_agent_id);
			
			if($stmt->execute())
			{	
				return true;
			}
			return false;
		}
	}
	
	//10-9-202o NEW RUNNING
	function get_sp_dp_tp_type_related_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$type)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda`=? AND `type`=? "))
		{
			$stmt->bind_param("ss",$passed_val,$type);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	//11-9-2020
	function get_family_type_related_data_running($buisness_main_title,$buisness_sub_title,$searched_date,$chart_data,$type)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `type`=? AND CHAR_LENGTH(`aakda`)=3 AND `aakda` IN ($chart_data) "))
		{
			$stmt->bind_param("s",$type);
			
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				
				if($stmt->fetch())
				{
					
					return $sum_paise;
				}
			}
			return false;
		}
	}
	function get_agents_data_by_police_station($police_station)
	{
		$stmt = "";
		if($police_station=="all")
		{
			$police_station	=	"";
			$stmt = "  `police_station` LIKE '%%'";
		}
		else
		{
			$stmt=" `police_station`='".$police_station."'";
		}
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `user_id`, `password`, `date`, `time`,`agent_commission` FROM `agent` WHERE ".$stmt))
		{
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time,$agent_commission);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$user_id;
					$data[$cntr][6]	=	$password;
					$data[$cntr][7]	=	$date;
					$data[$cntr][8]	=	$time;
					$data[$cntr][9]	=	$agent_commission;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	//14-9-2020
	function get_ring_numbers_running_takta_close($buisness_main_title,$searched_date,$type)
	{
		
		
		if($stmt = $this->con->prepare("SELECT `aakda` , `paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%'  AND `date`='".$searched_date."' AND `type`=?"))
		{
			 $stmt->bind_param("s",$type);
			
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$aakda;
					$data[$cntr][1]	=	$paise;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_total_sum_of_open_dhanda($search_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt_select = $this->con->prepare("SELECT SUM(`total_amount`) From `agent_aakde` WHERE `date`=? AND `buisness_main_title`=? AND `buisness_sub_title`=?"))
		{
			$stmt_select->bind_param("sss",$search_date,$buisness_main_title,$buisness_sub_title);
			
			$stmt_select->bind_result($res_id);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $res_id;
				}
				return false;
			}
		}
	}
	
	function get_total_sum_of_close_dhanda($search_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt_select = $this->con->prepare("SELECT SUM(`total_amount`) From `agent_aakde` WHERE `date`=? AND `buisness_main_title`=? AND `buisness_sub_title`=?"))
		{
			$stmt_select->bind_param("sss",$search_date,$buisness_main_title,$buisness_sub_title);
			
			$stmt_select->bind_result($res_id);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $res_id;
				}
				return false;
			}
		}
	}
	
	//21-3
	function get_all_agents_by_police_station($police_station,$chitthiwala)
	{
	    $police_station_stmt    =   "";
	    if($police_station=="all")
	    {
	        $police_station_stmt    =   " `police_station` LIKE '%%'";
	    }
	    else
	    {
	        $police_station_stmt    =   " `police_station`='".$police_station."'";
	    }
	    
	    $chitthiwala_stmt    =   "";
	    if($chitthiwala=="all")
	    {
	        $chitthiwala_stmt    =   " AND `chitthiwala` LIKE '%%'";
	    }
	    else
	    {
	        $chitthiwala_stmt    =   " AND `chitthiwala` = '".$chitthiwala."'";
	    }
	    
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `user_id`, `password`, `date`, `time` FROM `agent` WHERE ".$police_station_stmt.$chitthiwala_stmt))
		{
			
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$user_id,$password,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$user_id;
					$data[$cntr][6]	=	$password;
					$data[$cntr][7]	=	$date;
					$data[$cntr][8]	=	$time;
					
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	
	}
	function get_sum_of_khadi_dilele($agent_id)
	{
		
		if($stmt_select = $this->con->prepare("SELECT SUM(`amount`) FROM `khadi` WHERE `transaction_type`='credit' AND `agent_id`=?"))
		{
			$stmt_select->bind_param("s",$agent_id);
			
			$stmt_select->bind_result($res_id);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $res_id;
				}
				return false;
			}
		}
	}
	function get_sum_of_khadi_ghene($agent_id)
	{
		if($stmt_select = $this->con->prepare("SELECT SUM(`amount`) FROM `khadi` WHERE `transaction_type`='debit' AND `agent_id`=?"))
		{
			$stmt_select->bind_param("s",$agent_id);
			
			$stmt_select->bind_result($res_id);
			
			if($stmt_select->execute())
			{
				if($stmt_select->fetch())
				{
					return $res_id;
				}
				return false;
			}
		}
	}
		//8-7
	function delete_aakde_by_date($from_date,$to_date)
	{
		if($stmt =$this->con->prepare("DELETE FROM `agent_aakde` WHERE `date` BETWEEN ? AND ?"))
		{
			$stmt->bind_param("ss",$from_date,$to_date);
			if($stmt->execute())
			{
				return true;
				
			}
				return false;
		}
	}
	function get_agent_sangam_rate($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `sangam_rate` FROM `agent` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
				return False;
			}
		}
	}
}//End Of Class
?>