<?php
header( 'Content-Type: text/html; charset=utf-8');
date_default_timezone_set("Asia/Kolkata");
session_start();

header("Cache-Control: no cache");
session_cache_limiter("private_no_expire");	

$added_by	=	"";

$back_page_main_link = "http://www.ocbp.in/";

class db_functions
{
	private $con;
	
	function __construct()
	{
		$this->con = new mysqli("localhost","ocbp_admin_ocbp","r{rgG]3?XkG3","ocbp_db_ocbp");
		//$this->con = new mysqli("localhost","root","","ocbp_db_ocbp");

		mysqli_set_charset($this->con, 'utf8');
	}
	
	function get_admin_password($email)
		{
			if($stmt = $this->con->prepare("SELECT `password` FROM `admin` WHERE `user_id` = ?"))
			{
				$stmt->bind_param("s",$email);
				
				$stmt->bind_result($res_password);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_password;
					}
					return False;
				}
			}
		}
		
	function register_new_agent($agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$type,$thok_rakkam)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `agent`(`name`, `address`, `mobile_no`, `commission`, `oc_rate_chillar`, `oc_rate_thok`, `b_rate_chillar`, `b_rate_thok`, `p_rate_chillar`, `p_rate_thok`, `metro_rate_chillar`, `metro_rate_thok`, `parel_rate_chillar`, `parel_rate_thok`, `user_id`, `password`, `date`, `time`,`type`,`thok_rakkam`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssssssssssssss",$agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$date,$time,$type,$thok_rakkam);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	
	function get_agent_password($user_id)
	{
		if($stmt = $this->con->prepare("Select `password` from `agent` where `user_id` = ?"))
		{
			$stmt->bind_param("s",$user_id);

			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
			}
			return false;
		}
	}
	
	function get_magil_nave($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `chalu_nave` from `finance_manager` where `agent_id` = ? AND `saved_date`!=? AND `saved_date` < ? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("sss",$agent_res_id,$search_date,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	function get_plus_minus_data_from_vasuli_kagad($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `farak_dhanda`, `farak_jama` FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=? AND (`farak_dhanda`!='' OR `farak_jama`!='')"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_farak_dhanda,$res_farak_jama);
			
			if($stmt->execute())
			{
				$data = array();
				$cntr = 0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_farak_dhanda;
					$data[$cntr][1]	=	$res_farak_jama;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_vasuli_vatap_data_for_vasuli_kagad($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("SELECT `vasuli`, `vatap` FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=? AND (`vasuli`!='' OR `vatap`!='')"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_vasuli,$res_vatap);
			
			if($stmt->execute())
			{
				$data = array();
				$cntr = 0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_vasuli;
					$data[$cntr][1]	=	$res_vatap;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_chalu_nave_chalu_jama($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `chalu_nave`,`chalu_jama` from `finance_manager` where `agent_id` = ? AND `saved_date`=? AND (`farak_dhanda` > 0 OR `farak_jama` > 0) ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_chalu_nave,$res_chalu_jama);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_chalu_nave;
					$data[1]	=	$res_chalu_jama;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_vasuli_vatap_data($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];

		if($stmt = $this->con->prepare("Select `vasuli`,`vatap` from `finance_manager` where `agent_id` = ? AND `saved_date`=? AND (`vasuli`!='' OR `vatap`!='') ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_vasuli,$res_vatap);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_vasuli;
					$data[1]	=	$res_vatap;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_vasuli_vatap_data_from_date($search_date,$agent_name)
	{
		
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];

		if($stmt = $this->con->prepare("Select `agent_id`,`vasuli`,`vatap` from `finance_manager` where `saved_date`=? AND `agent_id`=? AND (`vasuli`!='' OR `vatap`!='') ORDER BY `id` ASC"))
		{
			$stmt->bind_param("ss",$search_date,$agent_name);

			$stmt->bind_result($res_agent_id,$res_vasuli,$res_vatap);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_agent_id;
					$data[$cntr][1]	=	$res_vasuli;
					$data[$cntr][2]	=	$res_vatap;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_shillak_data($agent_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `chalu_nave`,`chalu_jama` from `finance_manager` where `agent_id` = ? AND `saved_date` =? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_id,$search_date);

			$stmt->bind_result($res_chalu_nave,$res_chalu_jama);
			
			if($stmt->execute())
			{
				$data = array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_chalu_nave;
					$data[1]	=	$res_chalu_jama;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_aajche_nave_kalyan($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `aajche_nave` from `finance_manager` where `agent_id` = ? AND `saved_date`=? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	function get_aajche_nave_mumbai($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `aajche_nave_mumbai` from `finance_manager` where `agent_id` = ? AND `saved_date`=? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	function get_user_last_transaction_data($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `aajche_jama_mumbai`, `aajche_nave_mumbai`, `aajche_nave`, `aajche_jama`, `chalu_nave`, `chalu_jama`,`saved_date`, `farak_dhanda`, `farak_jama`, `vasuli`, `vatap`  FROM `finance_manager` WHERE  `agent_id` = ? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("s",$agent_id);

			$stmt->bind_result($id,$res_agent_id,$aajche_jama_mumbai,$aajche_nave_mumbai,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$saved_date,$farak_dhanda,$farak_jama,$vasuli,$vatap);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$id;
					$data[1]	=	$res_agent_id;
					$data[2]	=	$aajche_jama_mumbai;
					$data[3]	=	$aajche_nave_mumbai;
					$data[4]	=	$aajche_nave;
					$data[5]	=	$aajche_jama;
					$data[6]	=	$chalu_nave;
					$data[7]	=	$chalu_jama;
					$data[8]	=	$saved_date;
					$data[9]	=	$farak_dhanda;
					$data[10]	=	$farak_jama;
					$data[11]	=	$vasuli;
					$data[12]	=	$vatap;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_aajche_jama_kalyan($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `aajche_jama` from `finance_manager` where `agent_id` = ? AND `saved_date`=? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	function get_aajche_jama_mumbai($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
				
		if($stmt = $this->con->prepare("Select `aajche_jama_mumbai` from `finance_manager` where `agent_id` = ? AND `saved_date`=? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_magil_nave);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_magil_nave;
				}
			}
			return false;
		}
	}
	
	
	function get_magil_jama($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `chalu_jama` from `finance_manager` where `agent_id` = ? AND `saved_date`!=? AND `saved_date` < ? ORDER BY `id` DESC LIMIT 1"))
		{
			$stmt->bind_param("sss",$agent_res_id,$search_date,$search_date);

			$stmt->bind_result($magil_jama);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $magil_jama;
				}
			}
			return false;
		}
	}
	
	function check_rojnama_data_exist($agent_res_id,$search_date,$search_market)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `id` from `agent_rojnama_data` where `agent_id` = ? AND `saved_date` = ? AND `business_main_title` = ?"))
		{
			$stmt->bind_param("sss",$agent_res_id,$search_date,$search_market);

			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function get_payment_data_exist($agent_res_id,$search_date)
	{
		$date_data	=	explode("-",$search_date);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Select `id` from `finance_manager` where `agent_id` = ? AND `saved_date` = ?"))
		{
			$stmt->bind_param("ss",$agent_res_id,$search_date);

			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function get_total_transaction_data($agent_id,$search_date,$buisness_main_title)
	{
		
	$date_data	=	explode("-",$search_date);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
				
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `business_main_title`, `dhanda`, `payment`, `saved_date`, `o_thok`, `o_chillar`, `b_thok`, `b_chillar`, `c_thok`, `c_chillar`, `op_thok`, `op_chillar`, `op_t55`, `cp_thok`, `cp_chillar`, `cp_t55`, `date`, `time` FROM `agent_rojnama_data` WHERE `agent_id` =? AND `business_main_title` = ? AND `saved_date`=?"))
		{
			$stmt->bind_param("sss",$agent_id,$buisness_main_title,$search_date);

			$stmt->bind_result($id,$agent_id,$business_main_title,$dhanda,$payment,$saved_date,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$id;
					$data[1]	=	$agent_id;
					$data[2]	=	$business_main_title;
					$data[3]	=	$dhanda;
					$data[4]	=	$payment;
					$data[5]	=	$saved_date;
					$data[8]	=	$o_thok;
					$data[9]	=	$o_chillar;
					$data[10]	=	$b_thok;
					$data[11]	=	$b_chillar;
					$data[12]	=	$c_thok;
					$data[13]	=	$c_chillar;
					$data[14]	=	$op_thok;
					$data[15]	=	$op_chillar;
					$data[16]	=	$op_t55;
					$data[17]	=	$cp_thok;
					$data[18]	=	$cp_chillar;
					$data[19]	=	$cp_t55;
					$data[20]	=	$date;
					$data[21]	=	$time;
					
					return $data;
				}
			}
			return false;
		}
	}
	function get_total_transaction_data1($agent_id,$search_date,$buisness_main_title)
	{
		
	$date_data	=	explode("-",$search_date);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
				
		if($stmt = $this->con->prepare("SELECT `id`, `agent_id`, `business_main_title`, `dhanda`, `payment`, `saved_date`, `o_thok`, `o_chillar`, `b_thok`, `b_chillar`, `c_thok`, `c_chillar`, `op_thok`, `op_chillar`, `op_t55`, `cp_thok`, `cp_chillar`, `cp_t55`, `date`, `time` FROM `agent_rojnama_data` WHERE `agent_id` =? AND `business_main_title` = ? AND `saved_date`=?"))
		{
			$stmt->bind_param("sss",$agent_id,$buisness_main_title,$search_date);

			$stmt->bind_result($id,$agent_id,$business_main_title,$dhanda,$payment,$saved_date,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$id;
					$data[1]	=	$agent_id;
					$data[2]	=	$business_main_title;
					$data[3]	=	$dhanda;
					$data[4]	=	$payment;
					$data[5]	=	$saved_date;
					$data[8]	=	$o_thok;
					$data[9]	=	$o_chillar;
					$data[10]	=	$b_thok;
					$data[11]	=	$b_chillar;
					$data[12]	=	$c_thok;
					$data[13]	=	$c_chillar;
					$data[14]	=	$op_thok;
					$data[15]	=	$op_chillar;
					$data[16]	=	$op_t55;
					$data[17]	=	$cp_thok;
					$data[18]	=	$cp_chillar;
					$data[19]	=	$cp_t55;
					$data[20]	=	$date;
					$data[21]	=	$time;
					
					return $data;
				}
			}
			return false;
		}
	}
	function check_todays_rojnama_mgmt_exist($search_date,$search_market)
	{
		if($stmt = $this->con->prepare("Select `id` from `rojnama_buisness_mgmt` where `saved_date` = ? AND `business_main_title` = ?"))
		{
			$stmt->bind_param("ss",$search_date,$search_market);

			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function get_complete_dhanda_of_agent_from_complete_db($agent_id)
	{
		if($stmt = $this->con->prepare("Select SUM(`dhanda`),SUM(`payment`) from `agent_rojnama_data` where `agent_id` = ?"))
		{
			$stmt->bind_param("s",$agent_id);

			$stmt->bind_result($res_sum_dhanda,$res_sum_payments);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data['dhanda']		=	$res_sum_dhanda;
					$data['payments']	=	$res_sum_payments;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_total_vasuli_vatap_from_agent($agent_id)
	{
		if($stmt = $this->con->prepare("Select SUM(`jama_paise`),SUM(`vatap_paise`) from `vasulti_vatap` where `agent_id` = ?"))
		{
			$stmt->bind_param("s",$agent_id);

			$stmt->bind_result($res_sum_jama,$res_sum_vatap);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data['jama']	=	$res_sum_jama;
					$data['vatap']	=	$res_sum_vatap;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_agent_name_from_id($agent_id)
	{
		
		if($stmt = $this->con->prepare("Select `name` from `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);

			$stmt->bind_result($res_name);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_name;
				}
			}
			return false;
		}
	}
	
	function get_agent_password_for_edit($user_id,$agent_id)
	{
		if($stmt = $this->con->prepare("Select `password` from `agent` where `user_id` = ? AND `agent_id`!=?"))
		{
			$stmt->bind_param("si",$user_id,$agent_id);

			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
			}
			return false;
		}
	}
	
	function get_agents_data()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `oc_rate_chillar`, `oc_rate_thok`, `b_rate_chillar`, `b_rate_thok`, `p_rate_chillar`, `p_rate_thok`, `metro_rate_chillar`, `metro_rate_thok`, `parel_rate_chillar`, `parel_rate_thok`, `user_id`, `password`, `date`, `time`,`type`,`thok_rakkam` FROM `agent`"))
		{
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$date,$time,$type,$thok_rakkam);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$oc_rate_chillar;
					$data[$cntr][6]	=	$oc_rate_thok;
					$data[$cntr][7]	=	$b_rate_chillar;
					$data[$cntr][8]	=	$b_rate_thok;
					$data[$cntr][9]	=	$p_rate_chillar;
					$data[$cntr][10]	=	$p_rate_thok;
					$data[$cntr][11]	=	$metro_rate_chillar;
					$data[$cntr][12]	=	$metro_rate_thok;
					$data[$cntr][13]	=	$parel_rate_chillar;
					$data[$cntr][14]	=	$parel_rate_thok;
					$data[$cntr][15]	=	$user_id;
					$data[$cntr][16]	=	$password;
					$data[$cntr][17]	=	$date;
					$data[$cntr][18]	=	$time;
					$data[$cntr][19]	=	$type;
					$data[$cntr][20]	=	$thok_rakkam;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_agents_data_from_agent_id($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `oc_rate_chillar`, `oc_rate_thok`, `b_rate_chillar`, `b_rate_thok`, `p_rate_chillar`, `p_rate_thok`, `metro_rate_chillar`, `metro_rate_thok`, `parel_rate_chillar`, `parel_rate_thok`, `user_id`, `password`, `date`, `time`,`type`,`thok_rakkam` FROM `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$date,$time,$type,$thok_rakkam);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$commission;
					$data[$cntr][5]	=	$oc_rate_chillar;
					$data[$cntr][6]	=	$oc_rate_thok;
					$data[$cntr][7]	=	$b_rate_chillar;
					$data[$cntr][8]	=	$b_rate_thok;
					$data[$cntr][9]	=	$p_rate_chillar;
					$data[$cntr][10]	=	$p_rate_thok;
					$data[$cntr][11]	=	$metro_rate_chillar;
					$data[$cntr][12]	=	$metro_rate_thok;
					$data[$cntr][13]	=	$parel_rate_chillar;
					$data[$cntr][14]	=	$parel_rate_thok;
					$data[$cntr][15]	=	$user_id;
					$data[$cntr][16]	=	$password;
					$data[$cntr][17]	=	$date;
					$data[$cntr][18]	=	$time;
					$data[$cntr][19]	=	$type;
					$data[$cntr][20]	=	$thok_rakkam;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function get_agent_data_from_id($agent_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `oc_rate_chillar`, `oc_rate_thok`, `b_rate_chillar`, `b_rate_thok`, `p_rate_chillar`, `p_rate_thok`, `metro_rate_chillar`, `metro_rate_thok`, `parel_rate_chillar`, `parel_rate_thok`, `user_id`, `password`, `date`, `time`,`type`,`thok_rakkam` FROM `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$date,$time,$type,$thok_rakkam);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[4]	=	$commission;
					$data[5]	=	$oc_rate_chillar;
					$data[6]	=	$oc_rate_thok;
					$data[7]	=	$b_rate_chillar;
					$data[8]	=	$b_rate_thok;
					$data[9]	=	$p_rate_chillar;
					$data[10]	=	$p_rate_thok;
					$data[11]	=	$metro_rate_chillar;
					$data[12]	=	$metro_rate_thok;
					$data[13]	=	$parel_rate_chillar;
					$data[14]	=	$parel_rate_thok;
					$data[15]	=	$user_id;
					$data[16]	=	$password;
					$data[17]	=	$date;
					$data[18]	=	$time;
					$data[19]	=	$type;
					$data[20]	=	$thok_rakkam;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function delete_agent($agent_id)
	{
		if($stmt = $this->con->prepare("Delete from `agent` where `id` = ?"))
		{
			$stmt->bind_param("i",$agent_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_finance_manager_data($agent_id,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("DELETE FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=?"))
		{
			$stmt->bind_param("ss",$agent_id,$taarikh);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_rojnama_data($agent_id,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("DELETE FROM `agent_rojnama_data` WHERE `agent_id`=? AND `date`=?"))
		{
			$stmt->bind_param("ss",$agent_id,$taarikh);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_agent_aakde_data($agent_id,$taarikh,$buisness_main_title,$buisness_sub_title)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("DELETE FROM `agent_aakde` WHERE `agent`=? AND `buisness_main_title`=? AND `buisness_sub_title`=? AND `date`=?"))
		{
			$stmt->bind_param("ssss",$agent_id,$buisness_main_title,$buisness_sub_title,$taarikh);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function delete_agent_aakde_data1($count)
	{
	
		
		if($stmt = $this->con->prepare("DELETE FROM `agent_aakde` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$count);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_new_agent($agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$agent_id,$type,$thok_rakkam)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `agent` SET `name`=?,`address`=?,`mobile_no`=?,`commission`=?,`oc_rate_chillar`=?,`oc_rate_thok`=?,`b_rate_chillar`=?,`b_rate_thok`=?,`p_rate_chillar`=?,`p_rate_thok`=?,`metro_rate_chillar`=?,`metro_rate_thok`=?,`parel_rate_chillar`=?,`parel_rate_thok`=?,`user_id`=?,`password`=?,`date`=?,`time`=?,`type`=?,`thok_rakkam`=? WHERE `id`=?"))
		{
			$stmt->bind_param("ssssssssssssssssssssi",$agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$date,$time,$type,$thok_rakkam,$agent_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_winner_aakda_val_exist($buisness_main_title,$buisness_sub_title,$aakda_date)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `winner_aakda` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `winner_date`=?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_id);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function get_cutting_aakda_val_exist($buisness_main_title,$buisness_sub_title,$aakda_date)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `cutting_aakde` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `tarikh`=?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_id);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function save_winner_aakda($buisness_main_title,$buisness_sub_title,$patta_val,$aakda_val,$aakda_date)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `winner_aakda`(`business_main_title`, `business_sub_title`, `patta`, `aakda`, `winner_date`, `date`, `time`) VALUES (?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssss",$buisness_main_title,$buisness_sub_title,$patta_val,$aakda_val,$aakda_date,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function insert_new_transaction_details($res_agent_id,$aajche_jama_mumbai,$aajche_nave_mumbai,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$taarikh,$farak_dhanda,$farak_jama,$vasuli,$vatap)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$date = date("Y-m-d");
		$time = date("h:i:s A");

		if($stmt = $this->con->prepare("INSERT INTO `finance_manager`(`agent_id`, `aajche_jama_mumbai`, `aajche_nave_mumbai`, `aajche_nave`, `aajche_jama`, `chalu_nave`, `chalu_jama`, `saved_date`, `farak_dhanda`, `farak_jama`, `date`, `time`, `vasuli`, `vatap`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssssssss",$res_agent_id,$aajche_jama_mumbai,$aajche_nave_mumbai,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$taarikh,$farak_dhanda,$farak_jama,$date,$time,$vasuli,$vatap);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function insert_pay_todays($agent_res_id,$search_date,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$aajche_nave_mumbai,$aajche_jama_mumbai)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("INSERT INTO `finance_manager`(`agent_id`, `aajche_nave`, `aajche_jama`, `chalu_nave`, `chalu_jama`, `saved_date`, `date`, `time`,`aajche_nave_mumbai`,`aajche_jama_mumbai`) VALUES (?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssss",$agent_res_id,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$search_date,$date,$time,$aajche_nave_mumbai,$aajche_jama_mumbai);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_pay_todays($agent_res_id,$search_date,$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$pay_exist_id,$aajche_nave_mumbai,$aajche_jama_mumbai)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		if($stmt = $this->con->prepare("Update `finance_manager` SET `aajche_nave` = ?, `aajche_jama`=?, `chalu_nave`=?, `chalu_jama`=?,`saved_date`=?,`aajche_nave_mumbai`=?,`aajche_jama_mumbai`=? Where `id`=?"))
		{
			$stmt->bind_param("sssssssi",$aajche_nave,$aajche_jama,$chalu_nave,$chalu_jama,$search_date,$aajche_nave_mumbai,$aajche_jama_mumbai,$pay_exist_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function insert_rojnama_data_for_agent($agent_res_id,$search_date,$dhanda,$search_market,$total_final_payment,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `agent_rojnama_data`(`agent_id`, `business_main_title`, `dhanda`, `payment`, `saved_date`, `o_thok`, `o_chillar`, `b_thok`, `b_chillar`, `c_thok`, `c_chillar`, `op_thok`, `op_chillar`, `op_t55`, `cp_thok`, `cp_chillar`, `cp_t55`, `date`, `time`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssssssssssssssss",$agent_res_id,$search_market,$dhanda,$total_final_payment,$search_date,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_rojnama_data_for_agent($agent_res_id,$search_date,$dhanda,$search_market,$total_final_payment,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$exist_id)
	{
		$date_data	=	explode("-",$search_date);
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$date = date("Y-m-d");
		$time = date("h:i:s A");

		if($stmt = $this->con->prepare("UPDATE `agent_rojnama_data` SET `agent_id`=?,`business_main_title`=?,`dhanda`=?,`payment`=?,`saved_date`=?,`o_thok`=?,`o_chillar`=?,`b_thok`=?,`b_chillar`=?,`c_thok`=?,`c_chillar`=?,`op_thok`=?,`op_chillar`=?,`op_t55`=?,`cp_thok`=?,`cp_chillar`=?,`cp_t55`=?,`date`=?,`time`=? WHERE `id`=?"))
		{
			$stmt->bind_param("sssssssssssssssssssi",$agent_res_id,$search_market,$dhanda,$total_final_payment,$search_date,$o_thok,$o_chillar,$b_thok,$b_chillar,$c_thok,$c_chillar,$op_thok,$op_chillar,$op_t55,$cp_thok,$cp_chillar,$cp_t55,$date,$time,$exist_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function insert_rojnama_mgmt($open_utari,$close_utari,$total_utari,$open_passing,$close_passing,$total_passing,$search_date,$search_market)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `rojnama_buisness_mgmt`(`saved_date`, `open_uatri`, `open_passing`, `close_utari`, `close_passing`, `date`, `time`,`business_main_title`) VALUES (?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssss",$search_date,$open_utari,$open_passing,$close_utari,$close_passing,$date,$time,$search_market);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_rojnama_mgmt($open_utari,$close_utari,$total_utari,$open_passing,$close_passing,$total_passing,$search_date,$search_market)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `rojnama_buisness_mgmt` SET `saved_date`=?,`open_uatri`=?,`open_passing`=?,`close_utari`=?,`close_passing`=?,`date`=?,`time`=? WHERE `saved_date`=? AND `business_main_title` = ?"))
		{
			$stmt->bind_param("sssssssss",$search_date,$open_utari,$open_passing,$close_utari,$close_passing,$date,$time,$search_date,$search_market);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function save_agent_aakda($agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$date)
	{
		//$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `agent_aakde`(`agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`) VALUES (?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssss",$agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function save_cutting_aakda($buisness_main_title,$buisness_sub_title,$metro_patta,$sadha_patta,$parel_patta,$tarikh,$cutting_type)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `cutting_aakde`(`tarikh`, `business_main_title`, `business_sub_title`, `metro_patta`, `sadha_patta`, `parel_patta`, `date`, `time`,`cutting_type`) VALUES (?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssssss",$tarikh,$buisness_main_title,$buisness_sub_title,$metro_patta,$sadha_patta,$parel_patta,$date,$time,$cutting_type);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_agent_aakda($agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$edit_aakda)
	{
		if($stmt = $this->con->prepare("UPDATE `agent_aakde` SET `agent`=?,`buisness_main_title`=?,`buisness_sub_title`=?,`aakda`=?,`paise`=?,`added_by`=? WHERE `id`=?"))
		{
			$stmt->bind_param("ssssssi",$agent_name,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$edit_aakda);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_last_paise_of_agent($agent_name)
	{
		$date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("Select `paise` from `agent_aakde` where `agent` = ? AND `date` = ? ORDER By `id` DESC"))
		{
			$stmt->bind_param("ss",$agent_name,$date);

			$stmt->bind_result($res_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_paise;
				}
			}
			return false;
		}
	}
	
	function get_farak_data($agent_id,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		$taarikh	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
				
		if($stmt = $this->con->prepare("SELECT `farak_dhanda`, `farak_jama` FROM `finance_manager` WHERE `agent_id`=? AND `saved_date`=? AND (`farak_dhanda` > 0 OR `farak_jama` > 0) ORDER BY `id` DESC"))
		{
			$stmt->bind_param("ss",$agent_id,$taarikh);

			$stmt->bind_result($res_farak_dhanda,$res_farak_jama);
			
			if($stmt->execute())
			{
				$data = array();
				
				if($stmt->fetch())
				{
					$data[0] = $res_farak_dhanda;
					$data[1] = $res_farak_jama;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	
	function get_mgmt_data_from_date($search_date,$search_market)
	{
		$date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("SELECT `id`, `saved_date`, `open_uatri`, `open_passing`, `close_utari`, `close_passing`, `date`, `time` FROM `rojnama_buisness_mgmt` WHERE `saved_date`=? AND `business_main_title` = ?"))
		{
			$stmt->bind_param("ss",$search_date,$search_market);

			$stmt->bind_result($res_id, $res_saved_date, $res_open_uatri, $res_open_passing, $res_close_utari,$res_close_passing,$res_date,$res_time);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$res_saved_date;
					$data[2]	=	$res_open_uatri;
					$data[3]	=	$res_open_passing;
					$data[4]	=	$res_close_utari;
					$data[5]	=	$res_close_passing;
					$data[6]	=	$res_date;
					$data[7]	=	$res_time;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	
	function get_winner_data_from_date($winner_date)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `business_main_title`, `business_sub_title`, `patta`, `aakda`, `winner_date`, `date`, `time` FROM `winner_aakda` WHERE `winner_date`=?"))
		{
			$stmt->bind_param("s",$winner_date);

			$stmt->bind_result($id,$business_main_title,$business_sub_title,$patta,$aakda,$winner_date,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$business_main_title;
					$data[$cntr][2]	=	$business_sub_title;
					$data[$cntr][3]	=	$patta;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$winner_date;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_cutting_data_from_date($crt_date)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `tarikh`, `business_main_title`, `business_sub_title`, `metro_patta`, `sadha_patta`, `parel_patta`, `date`, `time`,`cutting_type` FROM `cutting_aakde` WHERE `tarikh`=?"))
		{
			$stmt->bind_param("s",$crt_date);

			$stmt->bind_result($id,$tarikh, $business_main_title, $business_sub_title, $metro_patta, $sadha_patta, $parel_patta, $date, $time,$cutting_type);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$tarikh;
					$data[$cntr][2]	=	$business_main_title;
					$data[$cntr][3]	=	$business_sub_title;
					$data[$cntr][4]	=	$metro_patta;
					$data[$cntr][5]	=	$sadha_patta;
					$data[$cntr][6]	=	$parel_patta;
					$data[$cntr][7]	=	$date;
					$data[$cntr][8]	=	$time;
					$data[$cntr][9]	=	$cutting_type;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_todays_aakde_data()
	{
		
		
		$todays_date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `date`=? ORDER by `id` DESC"))
		{
			$stmt->bind_param("s",$todays_date);

			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_aakde_data_from_search($agent_id,$taarikh,$aakda,$buisness_main_title,$buisness_sub_title)
	{
		$stmt = "";
		if($agent_id=="सर्व दाखवा")
		{
			$agent_id	=	"";
			$stmt = " AND `agent` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent`='".$agent_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
		if($aakda!="")
		{
			$stmt = $stmt." AND `aakda` = '".$aakda."' ";
		}
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt." ORDER BY `id` ASC "))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_open_close_dhanda_for_rojnama($agent_id,$taarikh,$buisness_main_title,$buisness_sub_title)
	{
		$stmt = "";
		if($agent_id=="सर्व दाखवा")
		{
			$agent_id	=	"";
			$stmt = " AND `agent` LIKE '%%'";
		}
		else if($agent_id!="")
		{
			$stmt = " AND `agent`='".$agent_id."'";
		}
		
		if($taarikh!="")
		{
			$data	=	explode("-",$taarikh);
			
			$taarikh	=	$data[2]."-".$data[1]."-".$data[0];
			
			$stmt = $stmt." AND `date` = '".$taarikh."' ";
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title`='".$buisness_main_title."' AND `buisness_sub_title` = '".$buisness_sub_title."'".$stmt))
		{
			$stmt->bind_result($paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $paise;
				}
			}
			return false;
		}
	}
	
	function get_aakde_data_from_id($edit_aakda)
	{
		$todays_date	=	date("Y-m-d");
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$edit_aakda);

			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function delete_winner_aakda($win_del_id)
	{
		if($stmt = $this->con->prepare("Delete from `winner_aakda` where `id` = ?"))
		{
			$stmt->bind_param("i",$win_del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_cutting_aakda($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `cutting_aakde` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function delete_agent_aakda($del_id)
	{
		if($stmt = $this->con->prepare("Delete from `agent_aakde` where `id` = ?"))
		{
			$stmt->bind_param("i",$del_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_sadha_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999') AND `aakda` NOT LIKE '%00%' AND `aakda` NOT LIKE '%11%' AND `aakda` NOT LIKE '%22%' AND `aakda` NOT LIKE '%33%' AND `aakda` NOT LIKE '%44%' AND `aakda` NOT LIKE '%55%' AND `aakda` NOT LIKE '%66%' AND `aakda` NOT LIKE '%77%' AND `aakda` NOT LIKE '%88%' AND `aakda` NOT LIKE '%99%' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."'"))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_sadha_unique_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT DISTINCT (`aakda`) FROM `agent_aakde` WHERE CHAR_LENGTH(`aakda`)=3 AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999') AND `aakda` NOT LIKE '%00%' AND `aakda` NOT LIKE '%11%' AND `aakda` NOT LIKE '%22%' AND `aakda` NOT LIKE '%33%' AND `aakda` NOT LIKE '%44%' AND `aakda` NOT LIKE '%55%' AND `aakda` NOT LIKE '%66%' AND `aakda` NOT LIKE '%77%' AND `aakda` NOT LIKE '%88%' AND `aakda` NOT LIKE '%99%' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."'"))
		{
			$stmt->bind_result($aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_sadha_aakde_for_sending($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`aakda` FROM `agent_aakde` WHERE CHAR_LENGTH(`aakda`)=3 AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999') AND `aakda` NOT LIKE '%00%' AND `aakda` NOT LIKE '%11%' AND `aakda` NOT LIKE '%22%' AND `aakda` NOT LIKE '%33%' AND `aakda` NOT LIKE '%44%' AND `aakda` NOT LIKE '%55%' AND `aakda` NOT LIKE '%66%' AND `aakda` NOT LIKE '%77%' AND `aakda` NOT LIKE '%88%' AND `aakda` NOT LIKE '%99%' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."'"))
		{
			$stmt->bind_result($res_id,$aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_metro_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND (`aakda` LIKE '%00%' OR `aakda` LIKE '%11%' OR `aakda` LIKE '%22%' OR `aakda`  LIKE '%33%' OR `aakda`  LIKE '%44%' OR `aakda`  LIKE '%55%' OR `aakda`  LIKE '%66%' OR `aakda`  LIKE '%77%' OR `aakda`  LIKE '%88%' OR `aakda`  LIKE '%99%') AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_metro_unique_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT DISTINCT(`aakda`) FROM `agent_aakde` WHERE  CHAR_LENGTH(`aakda`)=3 AND (`aakda` LIKE '%00%' OR `aakda` LIKE '%11%' OR `aakda` LIKE '%22%' OR `aakda`  LIKE '%33%' OR `aakda`  LIKE '%44%' OR `aakda`  LIKE '%55%' OR `aakda`  LIKE '%66%' OR `aakda`  LIKE '%77%' OR `aakda`  LIKE '%88%' OR `aakda`  LIKE '%99%') AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_metro_aakde_for_sending($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`aakda` FROM `agent_aakde` WHERE  CHAR_LENGTH(`aakda`)=3 AND (`aakda` LIKE '%00%' OR `aakda` LIKE '%11%' OR `aakda` LIKE '%22%' OR `aakda`  LIKE '%33%' OR `aakda`  LIKE '%44%' OR `aakda`  LIKE '%55%' OR `aakda`  LIKE '%66%' OR `aakda`  LIKE '%77%' OR `aakda`  LIKE '%88%' OR `aakda`  LIKE '%99%') AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` NOT IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($res_id,$aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_parel_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_parel_unique_aakde($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT DISTINCT(`aakda`) FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_parel_aakde_for_sending($searched_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`aakda` FROM `agent_aakde` WHERE   CHAR_LENGTH(`aakda`)=3 AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` IN ('000','111','222','333','444','555','666','777','888','999')"))
		{
			$stmt->bind_result($res_id,$aakda);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$aakda;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	
	function get_sum_of_aakda($searched_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `aakda` = '".$patta."' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `sent`=''"))
		{
			$stmt->bind_result($total_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $total_paise;
				}
			}
			return false;
		}
	}
	
	function get_sum_of_amount_not_cutted($res_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT `not_cutted_values` FROM `shillak_rakkam` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=? AND `patta`=?"))
		{
			$stmt->bind_param("ssss",$res_date,$buisness_main_title,$buisness_sub_title,$patta);
			
			$stmt->bind_result($r_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $r_paise;
				}
			}
			return false;
		}
	}
	
	
	function get_malkala_gelele_amount($searched_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT `malkala_gelele_paise` FROM `shillak_rakkam` WHERE `patta` = '".$patta."' AND `business_main_title` LIKE '%".$buisness_main_title."%' AND `business_sub_title` LIKE '%".$buisness_sub_title."%' AND `tarikh`='".$searched_date."'"))
		{
			$stmt->bind_result($total_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $total_paise;
				}
			}
			return false;
		}
	}
	
	function get_sum_of_aakda_in_utari($searched_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `aakda` = '".$patta."' AND `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."'"))
		{
			$stmt->bind_result($total_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $total_paise;
				}
			}
			return false;
		}
	}
	
	function get_sadha_set_value($tarikh,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `sadha_patta` FROM `cutting_aakde` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=?"))
		{
			$stmt->bind_param("sss",$tarikh,$buisness_main_title,$buisness_sub_title);
			
			$stmt->bind_result($res_sadha_patta);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $res_sadha_patta;
				}
			}
			return false;
		}
	}
	
	function get_metro_set_value($tarikh,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `metro_patta` FROM `cutting_aakde` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=?"))
		{
			$stmt->bind_param("sss",$tarikh,$buisness_main_title,$buisness_sub_title);
			
			$stmt->bind_result($res_patta);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $res_patta;
				}
			}
			return false;
		}
	}
	
	function get_parel_set_value($tarikh,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `parel_patta` FROM `cutting_aakde` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=?"))
		{
			$stmt->bind_param("sss",$tarikh,$buisness_main_title,$buisness_sub_title);
			
			$stmt->bind_result($res_patta);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{				
					return $res_patta;
				}
			}
			return false;
		}
	}
	
	function get_open_load_sheet_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` LIKE '".$passed_val."%' AND CHAR_LENGTH(`aakda`)<=2"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function delete_todays_aakde_data()
	{
		if($stmt = $this->con->prepare("Delete from `agent_aakde`"))
		{
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_winner_aakda($aakda_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `aakda` FROM `winner_aakda` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `winner_date`=?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_aakda);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_aakda;
				}
			}
			return false;
		}
	}
	
	function get_winner_patta($aakda_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("SELECT `patta` FROM `winner_aakda` WHERE `business_main_title`= ? AND `business_sub_title`=? AND `winner_date`=?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$aakda_date);

			$stmt->bind_result($res_aakda);

			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_aakda;
				}
			}
			return false;
		}
	}
	
	function get_close_load_sheet_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_thok_value($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_all_o_thok_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_o_chillar_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_thok_value_for_bracket($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	
	function get_all_b_thok_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_b_chillar_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_thok_value_for_patta($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_all_oc_patta_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_c_thok_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`>=100 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_all_c_chillar_data($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT `aakda`,`paise` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($aakda,$paise);
			
			if($stmt->execute())
			{
				$data	=	array();
				$counter = 0;
				
				while($stmt->fetch())
				{
					$data[$counter][0]	=	$aakda;
					$data[$counter][1]	=	$paise;
					
					$counter++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
				else
				{
					return false;
				}
			}
		}
	}
	
	function get_thok_value_for_chillar($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=3"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_chillar_value_for_bracket($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=2"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_chillar_value($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val,$agent_res_id)
	{
		if($searched_date!="")
		{
			$data	=	explode("-",$searched_date);
			
			$searched_date	=	$data[2]."-".$data[1]."-".$data[0];
		}
		
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` = '".$passed_val."' AND `paise`<=99 AND `agent`='".$agent_res_id."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_close_load_sheet_data_for_close_numbers($buisness_main_title,$buisness_sub_title,$searched_date,$passed_val)
	{
		if($stmt = $this->con->prepare("SELECT SUM(`paise`) FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND `buisness_sub_title` LIKE '%".$buisness_sub_title."%' AND `date`='".$searched_date."' AND `aakda` LIKE '".$passed_val."' AND CHAR_LENGTH(`aakda`)=1"))
		{
			$stmt->bind_result($sum_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $sum_paise;
				}
			}
			return false;
		}
	}
	
	function get_cutting_setting()
	{
		if($stmt = $this->con->prepare("Select `setting` from `cutting_setting`"))
		{
			$stmt->bind_result($setting);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $setting;
				}
			}
			return false;
		}
	}
	
	function get_set_cutting($res_date,$buisness_main_title,$buisness_sub_title)
	{
		if($stmt = $this->con->prepare("Select `cutting_type` from `cutting_aakde` where `business_main_title` = ? AND `business_sub_title` = ? AND `tarikh` = ?"))
		{
			$stmt->bind_param("sss",$buisness_main_title,$buisness_sub_title,$res_date);
			
			$stmt->bind_result($cutting_type);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $cutting_type;
				}
			}
			return false;
		}
	}
	
	function update_cutting_setting($setting)
	{
		if($stmt = $this->con->prepare("Update `cutting_setting` SET `setting` = ?"))
		{
			$stmt->bind_param("s",$setting);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function update_completed_commission($res_date,$buisness_main_title,$buisness_sub_title,$sadha_patta)
	{
		if($stmt = $this->con->prepare("UPDATE `shillak_rakkam` SET `not_cutted_values`=0 WHERE `tarikh` = ? AND `business_main_title` = ? AND `business_sub_title`=? AND `patta`=?"))
		{
			$stmt->bind_param("ssss",$res_date,$buisness_main_title,$buisness_sub_title,$sadha_patta);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}

	function save_todays_draw_commission($res_date,$buisness_main_title,$buisness_sub_title,$patta,$set_metro_val)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `saved_commission`(`buisness_main_title`, `buisness_sub_title`, `tarikh`, `patta`, `completed_commission`, `date`, `time`) VALUES (?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssss",$buisness_main_title,$buisness_sub_title,$res_date,$patta,$set_metro_val,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
		}
		return false;
	}
	
	function save_shillak_of_akda($res_date,$buisness_main_title,$buisness_sub_title,$patta,$paise,$cutting_type,$malkala_gelele_total,$without_sadha_rahilele)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `shillak_rakkam`(`tarikh`, `business_main_title`, `business_sub_title`, `patta`, `shillak_paise`, `cutting_type`, `date`, `time`,`malkala_gelele_paise`,`not_cutted_values`) VALUES (?,?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("ssssssssss",$res_date,$buisness_main_title,$buisness_sub_title,$patta,$paise,$cutting_type,$date,$time,$malkala_gelele_total,$without_sadha_rahilele);
			
			if($stmt->execute())
			{
				return true;
			}
		}
		return false;
	}
	
	function get_commission_value_alredy_saved($res_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `saved_commission` WHERE `buisness_main_title`=? AND `buisness_sub_title`=? AND `tarikh`=? AND `patta`=?"))
		{
			$stmt->bind_param("ssss",$buisness_main_title,$buisness_sub_title,$res_date,$patta);
			
			$stmt->bind_result($r_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $r_id;
				}
			}
			return false;
		}
	}
	
	function get_shillak_patta_value_alredy_saved($res_date,$buisness_main_title,$buisness_sub_title,$patta)
	{
		if($stmt = $this->con->prepare("SELECT `shillak_paise` FROM `shillak_rakkam` WHERE `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=? AND `patta`=?"))
		{
			$stmt->bind_param("ssss",$res_date,$buisness_main_title,$buisness_sub_title,$patta);
			
			$stmt->bind_result($r_paise);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $r_paise;
				}
			}
			return false;
		}
	}
	
	function update_shillak_of_akda($res_date,$buisness_main_title,$buisness_sub_title,$patta,$shillak,$cutting_type,$malkala_gelele_total,$without_sadha_rahilele)
	{
		if($stmt = $this->con->prepare("UPDATE `shillak_rakkam` SET `shillak_paise`=?,`malkala_gelele_paise`=?,`not_cutted_values`=? Where `tarikh`=? AND `business_main_title`=? AND `business_sub_title`=? AND `patta`=? AND `cutting_type`=?"))
		{
			$stmt->bind_param("ssssssss",$shillak,$malkala_gelele_total,$without_sadha_rahilele,$res_date,$buisness_main_title,$buisness_sub_title,$patta,$cutting_type);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function generateRandomString($length = 10) {
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;
	}
	
	function set_numbers_sent($transaction_id,$sent_id_data)
	{
		if($stmt = $this->con->prepare("UPDATE `agent_aakde` SET `sent`='1',`transaction_id`='".$transaction_id."' WHERE `id` IN (".$sent_id_data.")"))
		{
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function register_new_user($su_full_name,$su_mobile_no,$su_address,$su_agent,$su_new_agent,$su_save_agent,$su_page_load,$su_cutting,$su_cutting_report,$su_orignal_load,$su_utari_cutting,$su_number,$su_enter_number,$su_save_number,$su_delete_number,$su_rojnama,$su_rk,$su_rm,$su_winner_no,$su_winner_e,$su_winner_save,$su_vasuli,$su_today_winner,$su_vasuli_v,$su_taka,$su_report,$su_find_no,$su_close,$su_ck,$su_cm,$su_open,$su_ok,$su_om,$su_user_id,$su_password,$su_pwd_update,$su_software,$su_setting,$su_new,$su_view,$su_staff,$su_staff_new,$su_staff_view,$su_offlinestaff,$su_offstaff_new,$su_offstaff_view,$su_market_set)
	{
	echo 111;
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `user`(`agent`, `new_agent`, `save_agent`, `page_load`, `cutting`, `cutting_report`, `orignal_load`, `utari_cutting`, `number`, `enter_number`, `save_number`, `delete_number`, `rojnama`, `rk`, `rm`, `winner_no`, `winner_e`, `winner_save`, `vasuli`, `today_winner`, `vasuli_v`, `taka`, `report`, `find_no`, `close`, `ck`, `cm`, `open`, `ok`, `om`, `name`, `address`, `mobile_no`, `date`, `time`, `user_id`, `password`, `change_password`, `software`, `setting`, `add_user`, `view_user`, `staff`, `new_staff`, `view_staff`, `offline_staff`, `offstaff_new`, `offstaff_view`, `market_setting`)VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"))
		{
			echo 111;
			$stmt->bind_param("sssssssssssssssssssssssssssssssssssssssssssssssss",$su_agent,$su_new_agent,$su_save_agent,$su_page_load,$su_cutting,$su_cutting_report,$su_orignal_load,$su_utari_cutting,$su_number,$su_enter_number,$su_save_number,$su_delete_number,$su_rojnama,$su_rk,$su_rm,$su_winner_no,$su_winner_e,$su_winner_save,$su_vasuli,$su_today_winner,$su_vasuli_v,$su_taka,$su_report,$su_find_no,$su_close,$su_ck,$su_cm,$su_open,$su_ok,$su_om,$su_full_name,$su_address,$su_mobile_no,$date,$time,$su_user_id,$su_password,$su_pwd_update,$su_software,$su_setting,$su_new,$su_view,$su_staff,$su_staff_new,$su_staff_view,$su_offlinestaff,$su_offstaff_new,$su_offstaff_view,$su_market_set);
			
			if($stmt->execute())
			{echo 111;
				return true;
			}
			return false;
		}
	}
	function get_user_data()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `new_agent`, `save_agent`, `page_load`, `cutting`, `cutting_report`, `orignal_load`, `utari_cutting`, `number`, `enter_number`, `save_number`, `rojnama`, `rk`, `rm`, `winner_no`, `winner_e`, `winner_save`, `vasuli`, `today_winner`, `vasuli_v`, `taka`, `report`, `find_no`, `close`, `ck`, `cm`, `open`, `ok`, `om`, `name`, `address`, `mobile_no`, `date`, `time` FROM `user`"))
		{
			$stmt->bind_result($res_id,$agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$full_name,$address,$mobile_no,$date,$time);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]		=	$res_id;
					$data[$cntr][1]		=	$agent;
					$data[$cntr][2]		=	$new_agent;
					$data[$cntr][3]		=	$save_agent;
					$data[$cntr][4]		=	$page_load;
					$data[$cntr][5]		=	$cutting;
					$data[$cntr][6]		=	$cutting_report;
					$data[$cntr][7]		=	$orignal_load;
					$data[$cntr][8]		=	$utari_cutting;
					$data[$cntr][9]		=	$number;
					$data[$cntr][10]	=	$enter_number;
					$data[$cntr][11]	=	$save_number;
					$data[$cntr][12]	=	$rojnama;
					$data[$cntr][13]	=	$rk;
					$data[$cntr][14]	=	$rm;
					$data[$cntr][15]	=	$winner_no;
					$data[$cntr][16]	=	$winner_e;
					$data[$cntr][17]	=	$winner_save;
					$data[$cntr][18]	=	$vasuli;
					$data[$cntr][19]	=	$today_winner;
					$data[$cntr][20]	=	$vasuli_v;
					$data[$cntr][21]	=	$taka;
					$data[$cntr][22]	=	$report;
					$data[$cntr][23]	=	$find_no;
					$data[$cntr][24]	=	$close;
					$data[$cntr][25]	=	$ck;
					$data[$cntr][26]	=	$cm;
					$data[$cntr][27]	=	$open;
					$data[$cntr][28]	=	$ok;
					$data[$cntr][29]	=	$om;
					$data[$cntr][30]	=	$full_name;
					$data[$cntr][31]	=	$address;
					$data[$cntr][32]	=	$mobile_no;
					$data[$cntr][33]	=	$date;
					$data[$cntr][34]	=	$time;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function delete_user($delet_id)
	{
		if($stmt = $this->con->prepare("Delete from `user` where `id` = ?"))
		{
			$stmt->bind_param("i",$delet_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_user_data_from_id($user_id)
	{
		
		if($stmt = $this->con->prepare("SELECT `id`,`agent`, `new_agent`, `save_agent`, `page_load`, `cutting`, `cutting_report`, `orignal_load`, `utari_cutting`, `number`, `enter_number`, `save_number`, `rojnama`, `rk`, `rm`, `winner_no`, `winner_e`, `winner_save`, `vasuli`, `today_winner`, `vasuli_v`, `taka`, `report`, `find_no`, `close`, `ck`, `cm`, `open`, `ok`, `om`, `name`, `address`, `mobile_no`,`user_id`,`password`,`software`,`setting`,`add_user`,`view_user`,`staff`, `new_staff`, `view_staff`, `offline_staff`, `offstaff_new`, `offstaff_view`, `market_setting`,`change_password`,`delete_number` FROM `user` WHERE `id`=?"))
		
		{
			
			$stmt->bind_param("i",$user_id);
			
			$stmt->bind_result($res_id,$agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$full_name,$address,$mobile_no,$user_id1,$password,$software,$setting,$new,$view,$su_staff,$su_staff_new,$su_staff_view,$su_offlinestaff,$su_offstaff_new,$su_offstaff_view,$su_market_set,$su_pwd_update,$delete_number);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent;
					$data[2]	=	$new_agent;
					$data[3]	=	$save_agent;
					$data[4]	=	$page_load;
					$data[5]	=	$cutting;
					$data[6]	=	$cutting_report;
					$data[7]	=	$orignal_load;
					$data[8]	=	$utari_cutting;
					$data[9]	=	$number;
					$data[10]	=	$enter_number;
					$data[11]	=	$save_number;
					$data[12]	=	$rojnama;
					$data[13]	=	$rk;
					$data[14]	=	$rm;
					$data[15]	=	$winner_no;
					$data[16]	=	$winner_e;
					$data[17]	=	$winner_save;
					$data[18]	=	$vasuli;
					$data[19]	=	$today_winner;
					$data[20]	=	$vasuli_v;
					$data[21]	=	$taka;
					$data[22]	=	$report;
					$data[23]	=	$find_no;
					$data[24]	=	$close;
					$data[25]	=	$ck;
					$data[26]	=	$cm;
					$data[27]	=	$open;
					$data[28]	=	$ok;
					$data[29]	=	$om;
					$data[30]	=	$full_name;
					$data[31]	=	$address;
					$data[32]	=	$mobile_no;
					$data[33]	=	$user_id1;
					$data[34]	=	$password;
					$data[35]	=	$software;
					$data[36]	=	$setting;
					$data[37]	=	$new;
					$data[38]	=	$view;
					$data[39]	=	$su_staff;
					$data[40]	=	$su_staff_new;
					$data[41]	=	$su_staff_view;
					$data[42]	=	$su_offlinestaff;
					$data[43]	=	$su_offstaff_new;
					$data[44]	=	$su_offstaff_view;
					$data[45]	=	$su_market_set;
					$data[46]   = 	$su_pwd_update;
					$data[47]   =	$delete_number;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function update_user_record($agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$full_name,$address,$mobile_no,$user_id1,$password,$software,$setting,$new,$view,$su_staff,$su_staff_new,$su_staff_view,$su_offlinestaff,$su_offstaff_new,$su_offstaff_view,$su_market_set,$su_pwd_update,$user_id,$su_delete_number)
	{
		$date = date("Y-m-d");
		$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("UPDATE `user` SET `agent`=?,`new_agent`=?,`save_agent`=?,`page_load`=?,`cutting`=?,`cutting_report`=?,`orignal_load`=?,`utari_cutting`=?,`number`=?,`enter_number`=?,`save_number`=?,`rojnama`=?,`rk`=?,`rm`=?,`winner_no`=?,`winner_e`=?,`winner_save`=?,`vasuli`=?,`today_winner`=?,`vasuli_v`=?,`taka`=?,`report`=?,`find_no`=?,`close`=?,`ck`=?,`cm`=?,`open`=?,`ok`=?,`om`=?,`name`=?,`address`=?,`mobile_no`=?,`user_id`=?, `password`=?,`software`=?,`setting`=?,`add_user`=?,`view_user`=?, `staff`=?,`new_staff`=?,`view_staff`=?,`offline_staff`=?,`offstaff_new`=?,`offstaff_view`=?,`market_setting`=?,`change_password`=?,`delete_number`=? WHERE `id`=?"))
		{
			$stmt->bind_param("sssssssssssssssssssssssssssssssssssssssssssssssi",$agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$full_name,$address,$mobile_no,$user_id1,$password,$software,$setting,$new,$view,$su_staff,$su_staff_new,$su_staff_view,$su_offlinestaff,$su_offstaff_new,$su_offstaff_view,$su_market_set,$su_pwd_update,$su_delete_number,$user_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_user_password($email)
		{
			if($stmt = $this->con->prepare("SELECT `password` FROM `user` WHERE `user_id` = ?"))
			{
				$stmt->bind_param("s",$email);
				
				$stmt->bind_result($res_password);
				
				if($stmt->execute())
				{
					if($stmt->fetch())
					{
						return $res_password;
					}
					return False;
				}
			}
		}
	
	function get_user_status($user_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`,`agent`, `new_agent`, `save_agent`, `page_load`, `cutting`, `cutting_report`, `orignal_load`, `utari_cutting`, `number`, `enter_number`, `save_number`,`delete_number`, `rojnama`, `rk`, `rm`, `winner_no`, `winner_e`, `winner_save`, `vasuli`, `today_winner`, `vasuli_v`, `taka`, `report`, `find_no`, `close`, `ck`, `cm`, `open`, `ok`, `om`,`software`,`setting`,`add_user`,`view_user`,`staff`, `new_staff`, `view_staff`, `offline_staff`, `offstaff_new`, `offstaff_view`,`market_setting`, `change_password` FROM `user` WHERE `user_id`=?"))
		{
			$stmt->bind_param("s",$user_id);
			
			$stmt->bind_result($res_id,$agent,$new_agent,$save_agent,$page_load,$cutting,$cutting_report,$orignal_load,$utari_cutting,$number,$enter_number,$save_number,$delete_number,$rojnama,$rk,$rm,$winner_no,$winner_e,$winner_save,$vasuli,$today_winner,$vasuli_v,$taka,$report,$find_no,$close,$ck,$cm,$open,$ok,$om,$software,$setting,$new,$view,$staff,$staffnew,$staffview,$offline_staff,$offstaffnew,$offstaffview,$market_setting,$pwdupd);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent;
					$data[2]	=	$new_agent;
					$data[3]	=	$save_agent;
					$data[4]	=	$page_load;
					$data[5]	=	$cutting;
					$data[6]	=	$cutting_report;
					$data[7]	=	$orignal_load;
					$data[8]	=	$utari_cutting;
					$data[9]	=	$number;
					$data[10]	=	$enter_number;
					$data[11]	=	$save_number;
					$data[12]	=	$delete_number;
					$data[13]	=	$rojnama;
					$data[14]	=	$rk;
					$data[15]	=	$rm;
					$data[16]	=	$winner_no;
					$data[17]	=	$winner_e;
					$data[18]	=	$winner_save;
					$data[19]	=	$vasuli;
					$data[20]	=	$today_winner;
					$data[21]	=	$vasuli_v;
					$data[22]	=	$taka;
					$data[23]	=	$report;
					$data[24]	=	$find_no;
					$data[25]	=	$close;
					$data[26]	=	$ck;
					$data[27]	=	$cm;
					$data[28]	=	$open;
					$data[29]	=	$ok;
					$data[30]	=	$om;
					$data[31]	=	$software;
					$data[32]	=	$setting;
					$data[33]	=	$new;
					$data[34]	=	$view;
					$data[35]	=	$staff;
					$data[36]	= 	$staffnew;
					$data[37] 	=	$staffview;
					$data[38] 	= 	$offline_staff;
					$data[39] 	= 	$offstaffnew;
					$data[40]	= 	$offstaffview;
					$data[41]	= 	$market_setting;
					$data[42]	=	$pwdupd;
					return $data;
				}
			}
			return false;
		}
	}
	function update_user_new_password($new_password,$email)
	{
		
		if($stmt = $this->con->prepare("UPDATE `user` SET `password`=? WHERE `user_id`=?"))
		{
			$stmt->bind_param("ss",$new_password,$email);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	
	function get_offline_user_password($email)
	{
		if($stmt = $this->con->prepare("SELECT `password` FROM `offline-staff` WHERE `user_id` = ?"))
		{
			$stmt->bind_param("s",$email);
			
			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
				return False;
			}
		}
	}
	
	function get_user_status_block_active($email)
	{
		if($stmt = $this->con->prepare("SELECT `status` FROM `offline-staff` WHERE `user_id` = ?"))
		{
			$stmt->bind_param("s",$email);
			
			$stmt->bind_result($res_status);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_status;
				}
				return False;
			}
		}
	}
	
	function get_agent_id($userid)
	{
		if($stmt = $this->con->prepare("SELECT A.`id`, A.`name` FROM `agent` AS A INNER JOIN `staff_added_agent` AS B ON A.`id`=B.`agent_name` WHERE B.`staff_id`=?"))
		{
			$stmt->bind_param("s",$userid);
			$stmt->bind_result($res_id,$agent_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function check_random_stringexist($random_string)
	{
		
		if($stmt = $this->con->prepare("SELECT `id` FROM `agent_aakde` WHERE `random_string`=?"))
		{
			$stmt->bind_param("s",$random_string);

			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_id;
				}
			}
			return false;
		}
	}
	
	function save_agent_aakda_from_offline_entry($sel_agent,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$added_by,$date,$random_string,$time)
	{
		//$time = date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `agent_aakde`(`agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by`,`random_string`) VALUES (?,?,?,?,?,?,?,?,?)"))
		{
			$stmt->bind_param("sssssssss",$sel_agent,$buisness_main_title,$buisness_sub_title,$aakda_val,$paise_val,$date,$time,$added_by,$random_string);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_staff_password($su_user_id)
	{
		if($stmt = $this->con->prepare("SELECT `password` FROM `offline-staff` WHERE `user_id`=?"))
		{
			$stmt->bind_param("s",$su_user_id);
			
			$stmt->bind_result($res_password);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_password;
				}
				return False;
			}
		}
	}
	function register_new_offline_user($su_full_name,$su_mobile_no,$su_address,$su_user_id,$su_password)
	{
		$status	=	"active";
		$date 	= date("Y-m-d");
		$time 	= date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `offline-staff`(`name`, `address`, `mobile_no`, `user_id`, `password`, `status`, `date`, `time`) VALUES (?,?,?,?,?,?,?,?)"))
		{
			
			$stmt->bind_param("ssssssss",$su_full_name,$su_address,$su_mobile_no,$su_user_id,$su_password,$status,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function delete_offline_staff($delet_id)
	{
		if($stmt = $this->con->prepare("Delete from `offline-staff` where `id` = ?"))
		{
			$stmt->bind_param("i",$delet_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function get_offline_staff_data()
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `user_id`, `password`, `status`  FROM `offline-staff`"))
		{
			$stmt->bind_result($res_id,$full_name,$address,$mobile_no,$user_id,$password,$status);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$full_name;
					$data[$cntr][2]	=	$address;
					$data[$cntr][3]	=	$mobile_no;
					$data[$cntr][4]	=	$user_id;
					$data[$cntr][5]	=	$password;
					$data[$cntr][6]	=	$status;
					
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function get_offline_staff_data_from_id($user_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `user_id`, `password` FROM `offline-staff` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$user_id);
			
			$stmt->bind_result($res_id,$full_name,$address,$mobile_no,$user_id1,$password);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$full_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[4]	=	$user_id1;
					$data[5]	=	$password;
					
					return $data;
				}
			}
			return false;
		}
	}
	
	function update_offline_staff_record($full_name,$address,$mobile_no,$user_id1,$password,$user_id)
	{
		
		if($stmt = $this->con->prepare("UPDATE `offline-staff` SET `name`=?,`address`=?,`mobile_no`=?,`user_id`=?,`password`=? WHERE `id`=?"))
		{
			$stmt->bind_param("sssssi",$full_name,$address,$mobile_no,$user_id1,$password,$user_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function update_staff_status($status,$active_id)
	{
		
		if($stmt = $this->con->prepare("UPDATE `offline-staff` SET `status`=? WHERE `id`=?"))
		{
			$stmt->bind_param("si",$status,$active_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function add_new_agent($staff_user_id,$current_agent)
	{
		$date 	= date("Y-m-d");
		$time 	= date("h:i:s A");
		
		if($stmt = $this->con->prepare("INSERT INTO `staff_added_agent`(`staff_id`, `agent_name`, `date`, `time`) VALUES(?,?,?,?)"))
		{
			$stmt->bind_param("ssss",$staff_user_id,$current_agent,$date,$time);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function select_agent_id($current_agent,$staff_user_id)
	{
		if($stmt = $this->con->prepare("SELECT `agent_name` FROM `staff_added_agent` WHERE `staff_id`=? AND `agent_name`=?"))
		{
			$stmt->bind_param("ss",$staff_user_id,$current_agent);
			
			$stmt->bind_result($res_agent_id);
			
			if($stmt->execute())
			{
				if($stmt->fetch())
				{
					return $res_agent_id;
				}
				return False;
			}
		}
	}
	function get_agents_data_with_staff_id($staff_user_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `agent_name` FROM `staff_added_agent` WHERE `staff_id`=?"))
		{
			$stmt->bind_param("s",$staff_user_id);
			$stmt->bind_result($res_id,$agent_name);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					$data[$cntr][1]	=	$agent_name;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	function delete_staff_added_agent($delet_id)
	{
		if($stmt = $this->con->prepare("DELETE FROM `staff_added_agent` WHERE `id`=?"))
		{
			$stmt->bind_param("i",$delet_id);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_agent_id_vasuli()
	{
		if($stmt = $this->con->prepare("SELECT `id` FROM `agent`"))
		{
			
			$stmt->bind_result($res_id);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$res_id;
					
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
	
	function update_market_setting($main_title,$sub_title)
	{
		if($stmt = $this->con->prepare("UPDATE `market_setting` SET `main_business_title`=?,`sub_title`=?"))
		{
			$stmt->bind_param("ss",$main_title,$sub_title);
			
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
	function get_market_setting_details()
	{
		if($stmt = $this->con->prepare("SELECT `main_business_title`, `sub_title` FROM `market_setting`"))
		{
			$stmt->bind_result($main_business_title,$sub_title);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr 	= 	0;
				
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$main_business_title;
					$data[$cntr][1]	=	$sub_title;
					
					$cntr++;
				}
				
				if(!empty($data))
				{
					return $data;
				}
			}
			return false;
		}
	}
    function get_todays_aakde_data_by_select_title($buisness_main_title,$buisness_sub_title,$taarikh)
	{
		$date_data	=	explode("-",$taarikh);
		
		$search_date	=	$date_data[2]."-".$date_data[1]."-".$date_data[0];
		
		$query_stmt	=	"";
		if($buisness_sub_title=="ALL")
		{
			$query_stmt="";
		}
		else 
		{
			
			$query_stmt="AND `buisness_sub_title` = '".$buisness_sub_title."'";
		}
		
		
		
		if($stmt = $this->con->prepare("SELECT `id`, `agent`, `buisness_main_title`, `buisness_sub_title`, `aakda`, `paise`, `date`, `time`, `added_by` FROM `agent_aakde` WHERE `buisness_main_title` LIKE '%".$buisness_main_title."%' AND  `date`=? ".$query_stmt." ORDER BY `id` DESC"))
		{
			
			$stmt->bind_param("s",$search_date);

			$stmt->bind_result($id,$agent,$buisness_main_title,$buisness_sub_title,$aakda,$paise,$date,$time,$added_by);
			
			if($stmt->execute())
			{
				$data	=	array();
				$cntr	=	0;
				while($stmt->fetch())
				{
					$data[$cntr][0]	=	$id;
					$data[$cntr][1]	=	$agent;
					$data[$cntr][2]	=	$buisness_main_title;
					$data[$cntr][3]	=	$buisness_sub_title;
					$data[$cntr][4]	=	$aakda;
					$data[$cntr][5]	=	$paise;
					$data[$cntr][6]	=	$date;
					$data[$cntr][7]	=	$time;
					$data[$cntr][8]	=	$added_by;
					
					$cntr++;
				}
			}
			if(!empty($data))
			{
				return $data;
			}
			else
			{
				return false;
			}
		}
	}
	function get_agents_data_by_agent_id($agent_res_id)
	{
		if($stmt = $this->con->prepare("SELECT `id`, `name`, `address`, `mobile_no`, `commission`, `oc_rate_chillar`, `oc_rate_thok`, `b_rate_chillar`, `b_rate_thok`, `p_rate_chillar`, `p_rate_thok`, `metro_rate_chillar`, `metro_rate_thok`, `parel_rate_chillar`, `parel_rate_thok`, `user_id`, `password`, `date`, `time`,`type`,`thok_rakkam` FROM `agent` Where `id`=?"))
		{
			
			$stmt->bind_param("i",$agent_res_id);
			$stmt->bind_result($res_id,$agent_name,$address,$mobile_no,$commission,$oc_rate_chillar,$oc_rate_thok,$b_rate_chillar,$b_rate_thok,$p_rate_chillar,$p_rate_thok,$metro_rate_chillar,$metro_rate_thok,$parel_rate_chillar,$parel_rate_thok,$user_id,$password,$date,$time,$type,$thok_rakkam);
			
			if($stmt->execute())
			{
				$data	=	array();
				
				
				if($stmt->fetch())
				{
					$data[0]	=	$res_id;
					$data[1]	=	$agent_name;
					$data[2]	=	$address;
					$data[3]	=	$mobile_no;
					$data[4]	=	$commission;
					$data[5]	=	$oc_rate_chillar;
					$data[6]	=	$oc_rate_thok;
					$data[7]	=	$b_rate_chillar;
					$data[8]	=	$b_rate_thok;
					$data[9]	=	$p_rate_chillar;
					$data[10]	=	$p_rate_thok;
					$data[11]	=	$metro_rate_chillar;
					$data[12]	=	$metro_rate_thok;
					$data[13]	=	$parel_rate_chillar;
					$data[14]	=	$parel_rate_thok;
					$data[15]	=	$user_id;
					$data[16]	=	$password;
					$data[17]	=	$date;
					$data[18]	=	$time;
					$data[19]	=	$type;
					$data[20]	=	$thok_rakkam;
					
					return $data;
				}
				
				
			}
			return false;
		}
	}
	
	function truncate_agent_data($from_date,$to_date)
	{
		echo $from_date,$to_date;
		if($stmt = $this->con->prepare("DELETE FROM `agent`  WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date,$to_date);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_agent_aakade($from_date,$to_date)
	{
		if($stmt = $this->con->prepare("DELETE FROM `agent_aakde` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date,$to_date);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_agent_roznama_data($from_date,$to_date)
	{
		if($stmt = $this->con->prepare("DELETE FROM `agent_rojnama_data`   WHERE `date` BETWEEN ? AND ?  "))
		{
			$stmt->bind_param("ss",$from_date,$to_date);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_cutted_numbers_data()
	{
		if($stmt = $this->con->prepare("DELETE FROM `cutted_numbers_data` "))
		{
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_cutting_aakade_data($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `cutting_aakde` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_cutting_save_data($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `cutting_saved_data` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_cutting_setting($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `cutting_setting` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_finance_manger($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `finance_manager` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_market_setting($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `market_setting` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_offline_staff($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `offline-staff` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_roznama_b_mgmt($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `rojnama_buisness_mgmt` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_saved_commission($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `saved_commission` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_sent_id($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `sent_id` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_shillak_rakkam($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `shillak_rakkam` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_staff_added_agent($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `staff_added_agent` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	function truncate_winner_akkade($from_date1,$to_date1)
	{
		if($stmt = $this->con->prepare("DELETE FROM `winner_aakda` WHERE `date` BETWEEN ? AND ? "))
		{
			$stmt->bind_param("ss",$from_date1,$to_date1);
			if($stmt->execute())
			{
				return true;
			}
			return false;
		}
	}
	
}//End Of Class
?>