<?php  
	require_once('lib/functions.php');
	$db = new db_functions();
	
	require_once('date.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title>Tekale Gallery</title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width,height=device-height,initial-scale=1.0"/>
	<link rel="stylesheet" href="/js/bootstrap.min.css">
	<link rel="stylesheet" src="text/css" href="css/style.css">
	
	<link rel="stylesheet" href="js/jquery-ui-themes-1.12.1/themes/base/jquery-ui.css">
	
	<script src="js/jquery-1.12.4.js"></script>
	<script src="js/jquery-ui.js"></script>
	
	<script type="text/javascript">
	$(function() {
		var date = $('#datepicker').datepicker({ dateFormat: 'dd-mm-yy' }).val();
	});
	</script>
</head>
<body>

<?php
	include('header-patti.php');
?>

<div class="container box-draw">
    
	<?php
		$success_msg 	= 	0;
		$flag			=	0;
		$search_date	=	date("d-m-Y");
		$agent_id     =   "";
		
		if(isset($_POST['tarikh']))
		{
			$search_date			=	$_POST['tarikh'];
			$agent_id             =   $_POST['agent_name'];
			
			$_SESSION['s_tarikh']	=	$search_date;		
			$_SESSION['agent_s']	=	$agent_id;		
		}
		else if(isset($_SESSION['s_tarikh']))
		{
			$search_date				=	$_SESSION['s_tarikh'];
			$agent_id                 =   $_SESSION['agent_s'];		
		}
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
	
	<div class="page_main_title">वसुली / वाटप चार्ट </div>
	
	<?php
		if($success_msg==1)
		{
	?>
		<div style="color:Green;">रेकॉर्ड जतन केले आहे</div>
	<?php		
		}
	?>
	
	<div class="header">
		वार :  <?php echo $day;?> , दिनांक: <?php echo $date;?>
	</div>

	<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST" autocomplete="off">
	<div style="text-align:center;">
	<br /> 
		<a href="print-complete-saved-vasuli-vatap.php" style="font-size:15px; color:red;border:1px solid Red; padding:2px;display:inline-table;" target="_blank">Print Complete Report</a>
		<br /> 
	<select class="btn btn-primary dropdown-toggle button select" style="width:48%; margin-top:0px;" id="agent_name_id" name="agent_name">
		<?php
			$agents_data	=	$db->get_agents_data();
			
			if(!empty($agents_data))
			{
				$cntr_no	=	0;
				
				foreach($agents_data as $record)
				{
					$res_id				=	$record[0];
					$agent_name			=	$record[1];	
		?>
				<option value="<?php echo $res_id; ?>" <?php if($agent_id==$res_id){ ?>selected<?php } ?>><?php echo $agent_name; ?></option>
		<?php
				}
			}
		?>
	</select>
		
		<input type="text" id="datepicker" class="date" name="tarikh" placeholder="तारीख  ने शोधा" value="<?php echo $search_date; ?>" readonly style="width:48%; display:inline-table; padding:8px;" />
		
		<input type="submit" class="btn btn-primary btn-lg btn-block button col-lg-12 col-sm-12" name="search" value="SUBMIT" style="margin:0px; display:inline-table; margin-top:15px; margin-bottom:20px;" />
		<br /><br />
	</div>
	</form>
	<br /> <br />
		<a href="print-saved-vasuli-vatap.php" style="font-size:15px; color:red;border:1px solid Red; padding:2px;display:inline-table;" target="_blank">Print Report</a>
	<br /> <br />
<div style="width:100%; overflow-x:Scroll;">
<table class="table table-bordered">
    <thead>
      <tr style="background-color:#F0E68C;">
        <th id="th">श्री बालाजी </th>
        <th colspan="2" id="th">वसुली / वाटप चार्ट  (<?php echo $search_date; ?>)</th>
      </tr>
    </thead>
    <tbody>
      <tr style="background-color:#F0E68C;">
		<th style="text-align:center;">एजन्ट </th>
		<th style="text-align:center;">वसुली</th>
		<th style="text-align:center;">वाटप</th>
		<!--<th style="text-align:center;">बदला </th>-->
      </tr>	  
    </tbody>
	<tbody>
		<?php
		
		    $whatsapp_msg	=	"";
	
		    $whatsapp_msg = $whatsapp_msg."वसुली / वाटप %20 %0A %0A";
		    
		    $search_date = "";
		    $agent_id = "";
		    if(isset($_SESSION['s_tarikh']))
		    {
		        $search_date    =   $_SESSION['s_tarikh'];
    			$agent_id       =   $_SESSION['agent_s'];		
		    }
		    
		    $agent_new_name			=	$db->get_agent_name_from_id($agent_id);
	
	        $whatsapp_msg = $whatsapp_msg."एजन्ट : ".$agent_new_name."%20 %0A %0A";
	        
	        $whatsapp_msg = $whatsapp_msg."तारीख : ".$search_date."%20 %0A %0A";
    	    
    	    $whatsapp_msg = $whatsapp_msg."वसुली  - वाटप %20 %0A %0A";
    	    
			$total_vasuli	=	0;
			$total_vatap	=	0;
			
			$vasuli_vatap_data	=	array();
			$vasuli_vatap_data	=	$db->get_vasuli_vatap_data_from_date($search_date,$agent_id);
			
			if(!empty($vasuli_vatap_data))
			{
				$cntr	=	1;
				foreach($vasuli_vatap_data as $record)
				{
					$res_agent_id	=	$record[0];
					$res_vasuli		=	$record[1];
					$res_vatap		=	$record[2];
					$agent_name		=	"";
					
					$agent_record	=	$db->get_agent_data_from_id($res_agent_id);
	
					if(!empty($agent_record))
					{
						$agent_name			=	$agent_record[1];
					}
					
					$total_vasuli	=	$total_vasuli + $res_vasuli;
					$total_vatap	=	$total_vatap + $res_vatap;
					
					
					if($cntr!=1)
					{
					    $agent_name =   "";
					}
					
					$whatsapp_msg = $whatsapp_msg." ".$res_vasuli." - ".$res_vatap."%20 %0A %0A";
		?>
			<tr>
				<td><?php echo $agent_name; ?></td>
				<td><?php echo $res_vasuli; ?></td>
				<td><?php echo $res_vatap; ?></td>
				<!--<td><a href="vasuli_vatap_badala_chart.php">आकडे बदला</a></td>-->
			</tr>	  
		<?php
					$cntr++;
				}
		?>
			<tr style="background-color:#F0E68C; font-weight:bold;">
				<td>TOTAL</td>
				<td><?php echo $total_vasuli; ?></td>
				<td><?php echo $total_vatap; ?></td>
			</tr>
		<?php
		
		$whatsapp_msg = $whatsapp_msg."=============== %0A %0A";
		
		$whatsapp_msg = $whatsapp_msg." ".$total_vasuli." - ".$total_vatap."%20 %0A %0A";
			}
			else
			{
		?>
			<tr>
				<td colspan="4" style="color:red; font-weight:bold;">कोणतीही वसूली / वाटप उपलब्ध नाही</td>
			</tr>
		<?php
			}
		?>
    </tbody>
  </table>
  
  
  
  <br />
<br />
<a href="whatsapp://send?text=<?php echo $whatsapp_msg; ?>" class="share_btn"><img src="/images/whatsapp.png" data-action="share/whatsapp/share" />WhatsApp Report</a>

		   <br /><br />
</div>
		
	</div>

</body>
</html>